/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.records;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractQuerySqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBuilder
extends AbstractQuerySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SelectBuilder.class);
    private List<String> columns = new ArrayList<String>();
    private List<String> tables = new ArrayList<String>();
    private List<String> joins = new ArrayList<String>();
    private List<String> wheres = new ArrayList<String>();
    private List<String> orders = new ArrayList<String>();
    private List<String> groups = new ArrayList<String>();
    private List<String> unions = new ArrayList<String>();
    private boolean distinct = false;
    private String having = null;
    private int limit = -1;
    private int offset = -1;
    private boolean forUpdate = false;

    public SelectBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public SelectBuilder distinct() {
        logger.trace("distinct");
        this.distinct = true;
        return this;
    }

    public SelectBuilder forUpdate() {
        logger.trace("forUpdate");
        this.forUpdate = true;
        return this;
    }

    public SelectBuilder column(String column) {
        logger.trace("column: " + column);
        this.columns.add(column);
        return this;
    }

    public SelectBuilder from(String table) {
        logger.trace("from: " + table);
        return this.from(table, null);
    }

    public SelectBuilder from(String table, String alias) {
        logger.trace("from: " + table + ", alias: " + alias);
        StringBuilder snippet = new StringBuilder();
        snippet.append(table);
        if (alias != null) {
            snippet.append(" ").append("AS").append(" ").append(alias);
        }
        this.tables.add(snippet.toString());
        return this;
    }

    public SelectBuilder join(String table, String on) {
        logger.trace("join: " + table + ", on: " + on);
        return this.join(table, on, null);
    }

    public SelectBuilder join(String table, String on, String alias) {
        logger.trace("join: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("INNER", table, on, alias);
    }

    public SelectBuilder innerJoin(String table, String on) {
        logger.trace("innerJoin: " + table + ", on: " + on);
        return this.innerJoin(table, on, null);
    }

    public SelectBuilder innerJoin(String table, String on, String alias) {
        logger.trace("innerJoin: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("INNER", table, on, alias);
    }

    public SelectBuilder outerJoin(String table, String on) {
        logger.trace("outerJoin: " + table + ", on: " + on);
        return this.outerJoin(table, on, null);
    }

    public SelectBuilder outerJoin(String table, String on, String alias) {
        logger.trace("outerJoin: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("OUTER", table, on, alias);
    }

    public SelectBuilder leftJoin(String table, String on) {
        logger.trace("leftJoin: " + table + ", on: " + on);
        return this.leftJoin(table, on, null);
    }

    public SelectBuilder leftJoin(String table, String on, String alias) {
        logger.trace("leftJoin: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("LEFT", table, on, alias);
    }

    public SelectBuilder rightJoin(String table, String on) {
        logger.trace("rightJoin: " + table + ", on: " + on);
        return this.rightJoin(table, on, null);
    }

    public SelectBuilder rightJoin(String table, String on, String alias) {
        logger.trace("rightJoin: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("RIGHT", table, on, alias);
    }

    public SelectBuilder fullJoin(String table, String on) {
        logger.trace("fullJoin: " + table + ", on: " + on);
        return this.fullJoin(table, on, null);
    }

    public SelectBuilder fullJoin(String table, String on, String alias) {
        logger.trace("fullJoin: " + table + ", on: " + on + ", alias: " + alias);
        return this.genericJoin("FULL", table, on, alias);
    }

    public SelectBuilder genericJoin(String type, String table, String on, String alias) {
        logger.trace("genericJoin: " + type + ", table: " + table + ", on: " + on + ", alias: " + alias);
        StringBuilder snippet = new StringBuilder();
        snippet.append(type).append(" ").append("JOIN").append(" ").append(table).append(" ").append("ON").append(" ").append(on);
        if (alias != null) {
            snippet.append(" ").append(alias);
        }
        this.joins.add(snippet.toString());
        return this;
    }

    public SelectBuilder where(String condition) {
        logger.trace("where: " + condition);
        this.wheres.add("(" + condition + ")");
        return this;
    }

    public SelectBuilder order(String column) {
        logger.trace("order: " + column);
        return this.order(column, true);
    }

    public SelectBuilder order(String column, boolean asc) {
        logger.trace("order: " + column + ", asc: " + asc);
        if (asc) {
            this.orders.add(column + " " + "ASC");
        } else {
            this.orders.add(column + " " + "DESC");
        }
        return this;
    }

    public SelectBuilder group(String column) {
        logger.trace("group: " + column);
        this.groups.add(column);
        return this;
    }

    public SelectBuilder limit(int limit) {
        logger.trace("limit: " + limit);
        this.limit = limit;
        return this;
    }

    public SelectBuilder limit(Double limit) {
        logger.trace("limit: " + limit);
        return this.limit(limit.intValue());
    }

    public SelectBuilder offset(int offset) {
        logger.trace("offset: " + offset);
        this.offset = offset;
        return this;
    }

    public SelectBuilder offset(Double offset) {
        logger.trace("offset: " + offset);
        return this.offset(offset.intValue());
    }

    public SelectBuilder having(String having) {
        logger.trace("having: " + having);
        this.having = having;
        return this;
    }

    public SelectBuilder union(String select) {
        logger.trace("union: " + select);
        this.unions.add(select);
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateSelect(sql);
        this.generateDistinct(sql);
        this.generateColumns(sql);
        this.generateTables(sql);
        this.generateJoins(sql);
        this.generateWhere(sql, this.wheres);
        this.generateGroupBy(sql);
        this.generateHaving(sql);
        this.generateOrderBy(sql, this.orders);
        this.generateLimitAndOffset(sql, this.limit, this.offset);
        this.generateUnion(sql);
        this.generateForUpdate(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateUnion(StringBuilder sql) {
        if (!this.unions.isEmpty()) {
            sql.append(" ").append("UNION").append(" ").append(this.traverseUnions());
        }
    }

    protected void generateHaving(StringBuilder sql) {
        if (this.having != null) {
            sql.append(" ").append("HAVING").append(" ").append(this.having);
        }
    }

    protected void generateGroupBy(StringBuilder sql) {
        if (!this.groups.isEmpty()) {
            sql.append(" ").append("GROUP BY").append(" ").append(this.traverseGroups());
        }
    }

    protected void generateJoins(StringBuilder sql) {
        if (!this.joins.isEmpty()) {
            sql.append(" ").append(this.traverseJoins());
        }
    }

    protected void generateTables(StringBuilder sql) {
        sql.append(" ").append("FROM").append(" ").append(this.traverseTables());
    }

    protected void generateColumns(StringBuilder sql) {
        sql.append(" ").append(this.traverseColumns());
    }

    protected void generateDistinct(StringBuilder sql) {
        if (this.distinct) {
            sql.append(" ").append("DISTINCT");
        }
    }

    protected void generateForUpdate(StringBuilder sql) {
        if (this.forUpdate) {
            sql.append(" ").append("FOR UPDATE");
        }
    }

    protected String traverseColumns() {
        if (!this.columns.isEmpty()) {
            StringBuilder snippet = new StringBuilder();
            for (String column : this.columns) {
                snippet.append(column).append(",").append(" ");
            }
            return snippet.toString().substring(0, snippet.length() - 2);
        }
        return "*";
    }

    protected String traverseTables() {
        StringBuilder snippet = new StringBuilder();
        for (String table : this.tables) {
            snippet.append(table).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String traverseJoins() {
        StringBuilder snippet = new StringBuilder();
        for (String join : this.joins) {
            snippet.append(join).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String traverseGroups() {
        StringBuilder snippet = new StringBuilder();
        for (String group : this.groups) {
            snippet.append(group).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String traverseUnions() {
        StringBuilder snippet = new StringBuilder();
        for (String union : this.unions) {
            snippet.append(union).append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 1);
    }

    protected void generateSelect(StringBuilder sql) {
        sql.append("SELECT");
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public List<String> getJoins() {
        return this.joins;
    }

    public List<String> getWheres() {
        return this.wheres;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getUnions() {
        return this.unions;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getHaving() {
        return this.having;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

