/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.records;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractQuerySqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBuilder
extends AbstractQuerySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(UpdateBuilder.class);
    private String table;
    private Map<String, String> values = new LinkedHashMap<String, String>();
    private List<String> wheres = new ArrayList<String>();

    public UpdateBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public UpdateBuilder table(String table) {
        logger.trace("table: " + table);
        this.table = table;
        return this;
    }

    public UpdateBuilder set(String column, String value) {
        logger.trace("set: " + column + ", value: " + value);
        this.values.put(column, value);
        return this;
    }

    public UpdateBuilder where(String condition) {
        logger.trace("where: " + condition);
        this.wheres.add("(" + condition + ")");
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateUpdate(sql);
        this.generateTable(sql);
        this.generateSetValues(sql);
        this.generateWhere(sql, this.wheres);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        sql.append(" ").append(this.table);
    }

    protected void generateSetValues(StringBuilder sql) {
        sql.append(" ").append("SET");
        for (Map.Entry<String, String> next : this.values.entrySet()) {
            sql.append(" ").append(next.getKey()).append(" ").append("=").append(" ").append(next.getValue()).append(",");
        }
        if (this.values.entrySet().size() > 0) {
            sql.delete(sql.length() - 1, sql.length());
        }
    }

    protected void generateUpdate(StringBuilder sql) {
        sql.append("UPDATE");
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public List<String> getWheres() {
        return this.wheres;
    }
}

