/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.sequence;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSequenceBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateSequenceBuilder.class);
    private String sequence = null;
    private int start = 0;
    private int increment = 1;

    public CreateSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect);
        this.sequence = sequence;
    }

    public CreateSequenceBuilder start(int start) {
        logger.trace("start: " + start);
        this.start = start;
        return this;
    }

    public CreateSequenceBuilder increment(int increment) {
        logger.trace("increment: " + increment);
        this.increment = increment;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateSequence(sql);
        this.generateStart(sql);
        this.generateIncrement(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateSequence(StringBuilder sql) {
        sql.append(" ").append("SEQUENCE").append(" ").append(this.sequence);
    }

    protected void generateStart(StringBuilder sql) {
    }

    protected void generateIncrement(StringBuilder sql) {
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getIncrement() {
        return this.increment;
    }
}

