/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlException;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableCheckBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableForeignKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTablePrimaryKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableUniqueIndexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableBuilder.class);
    private String table = null;
    private List<String[]> columns = new ArrayList<String[]>();
    private CreateTablePrimaryKeyBuilder primaryKey;
    private List<CreateTableForeignKeyBuilder> foreignKeys = new ArrayList<CreateTableForeignKeyBuilder>();
    private List<CreateTableUniqueIndexBuilder> uniqueIndices = new ArrayList<CreateTableUniqueIndexBuilder>();
    private List<CreateTableCheckBuilder> checks = new ArrayList<CreateTableCheckBuilder>();

    public CreateTableBuilder(ISqlDialect dialect, String table) {
        super(dialect);
        this.table = table;
    }

    protected String getTable() {
        return this.table;
    }

    protected List<String[]> getColumns() {
        return this.columns;
    }

    public CreateTableBuilder column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        logger.trace("column: " + name + ", type: " + (type != null ? type.name() : null) + ", isPrimaryKey: " + isPrimaryKey + ", isNullable: " + isNullable + ", isUnique: " + isUnique + ", isIdentity: " + isIdentity + ", args: " + Arrays.toString(args));
        String[] definition = new String[]{name, this.getDialect().getDataTypeName(type)};
        String[] column = null;
        column = isIdentity != false ? (String[])Stream.of(definition, args, {this.getDialect().getIdentityArgument()}).flatMap(Stream::of).toArray(String[]::new) : (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        if (!isNullable.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getNotNullArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        if (isPrimaryKey.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getPrimaryKeyArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        if (isUnique.booleanValue() && !isPrimaryKey.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getUniqueArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        this.columns.add(column);
        return this;
    }

    public CreateTableBuilder column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, type, isPrimaryKey, isNullable, isUnique, false, args);
    }

    public CreateTableBuilder column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, type, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, type, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, DataType type, Boolean isPrimaryKey) {
        return this.column(name, type, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, DataType type) {
        return this.column(name, type, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder column(String name, int type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, int type, Boolean isPrimaryKey) {
        return this.column(name, DataType.values()[type], isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, int type) {
        return this.column(name, DataType.values()[type], (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, Double type, Boolean isPrimaryKey) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, Double type) {
        return this.column(name, DataType.values()[type.intValue()], (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder column(String name, String type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, String type, Boolean isPrimaryKey) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, String type) {
        return this.column(name, DataType.valueOf(type), (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + length + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.VARCHAR, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, new String[0]);
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, false);
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, false);
    }

    public CreateTableBuilder columnVarchar(String name, int length, Boolean isPrimaryKey) {
        return this.columnVarchar(name, length, isPrimaryKey, true);
    }

    public CreateTableBuilder columnVarchar(String name, int length) {
        return this.columnVarchar(name, length, false);
    }

    public CreateTableBuilder columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + length + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.CHAR, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public CreateTableBuilder columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, isUnique, false, this.splitValues(args));
    }

    public CreateTableBuilder columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, isUnique, false, new String[0]);
    }

    public CreateTableBuilder columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, false);
    }

    public CreateTableBuilder columnChar(String name, int length, Boolean isPrimaryKey) {
        return this.columnChar(name, length, isPrimaryKey, true);
    }

    public CreateTableBuilder columnChar(String name, int length) {
        return this.columnChar(name, length, false);
    }

    public CreateTableBuilder columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.DATE, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnDate(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDate(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnDate(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDate(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDate(String name, Boolean isPrimaryKey) {
        return this.columnDate(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDate(String name) {
        return this.columnDate(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TIME, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTime(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTime(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnTime(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTime(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTime(String name, Boolean isPrimaryKey) {
        return this.columnTime(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTime(String name) {
        return this.columnTime(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TIMESTAMP, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTimestamp(String name, Boolean isPrimaryKey) {
        return this.columnTimestamp(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTimestamp(String name) {
        return this.columnTimestamp(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        return this.column(name, DataType.INTEGER, isPrimaryKey, isNullable, isUnique, isIdentity, args);
    }

    public CreateTableBuilder columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnInteger(name, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public CreateTableBuilder columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnInteger(name, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnInteger(name, isPrimaryKey, isNullable, false);
    }

    public CreateTableBuilder columnInteger(String name, Boolean isPrimaryKey) {
        return this.columnInteger(name, isPrimaryKey, true);
    }

    public CreateTableBuilder columnInteger(String name) {
        return this.columnInteger(name, false);
    }

    public CreateTableBuilder columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TINYINT, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTinyint(String name, Boolean isPrimaryKey) {
        return this.columnTinyint(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnTinyint(String name) {
        return this.columnTinyint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        return this.column(name, DataType.BIGINT, isPrimaryKey, isNullable, isUnique, isIdentity, args);
    }

    public CreateTableBuilder columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnBigint(name, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public CreateTableBuilder columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnBigint(name, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnBigint(name, isPrimaryKey, isNullable, false);
    }

    public CreateTableBuilder columnBigint(String name, Boolean isPrimaryKey) {
        return this.columnBigint(name, isPrimaryKey, true);
    }

    public CreateTableBuilder columnBigint(String name) {
        return this.columnBigint(name, false);
    }

    public CreateTableBuilder columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.SMALLINT, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnSmallint(String name, Boolean isPrimaryKey) {
        return this.columnSmallint(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnSmallint(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.REAL, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnReal(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnReal(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnReal(String name, Boolean isPrimaryKey) {
        return this.columnReal(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnReal(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.DOUBLE, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnDouble(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDouble(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDouble(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDouble(String name, Boolean isPrimaryKey) {
        return this.columnDouble(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDouble(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.BOOLEAN, isPrimaryKey, isNullable, isUnique, args);
    }

    public CreateTableBuilder columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public CreateTableBuilder columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public CreateTableBuilder columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBoolean(String name, Boolean isPrimaryKey) {
        return this.columnBoolean(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBoolean(String name) {
        return this.columnBoolean(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnBlob(String name, Boolean isNullable, String ... args) {
        return this.column(name, DataType.BLOB, (Boolean)false, isNullable, (Boolean)false, args);
    }

    public CreateTableBuilder columnBlob(String name, Boolean isNullable, String args) {
        return this.columnBlob(name, isNullable, this.splitValues(args));
    }

    public CreateTableBuilder columnBlob(String name, Boolean isNullable) {
        return this.columnBlob(name, isNullable, new String[0]);
    }

    public CreateTableBuilder columnBlob(String name) {
        return this.columnBlob(name, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + precision + "," + scale + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.DECIMAL, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, false);
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, true);
    }

    public CreateTableBuilder columnDecimal(String name, int precision, int scale) {
        return this.columnDecimal(name, precision, scale, false);
    }

    public CreateTableBuilder columnBit(String name, Boolean isNullable, String ... args) {
        return this.column(name, DataType.BIT, (Boolean)false, isNullable, (Boolean)false, args);
    }

    public CreateTableBuilder columnBit(String name, Boolean isNullable, String args) {
        return this.columnBit(name, isNullable, this.splitValues(args));
    }

    public CreateTableBuilder columnBit(String name, Boolean isNullable) {
        return this.columnBit(name, isNullable, new String[0]);
    }

    public CreateTableBuilder columnBit(String name) {
        return this.columnBit(name, (Boolean)false, new String[0]);
    }

    public CreateTableBuilder primaryKey(String name, String[] columns) {
        logger.trace("primaryKey: " + name + ", columns" + Arrays.toString(columns));
        if (this.primaryKey != null) {
            throw new SqlException("Setting of primary key must be called only once");
        }
        this.primaryKey = new CreateTablePrimaryKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            this.primaryKey.column(column);
        }
        return this;
    }

    public CreateTableBuilder primaryKey(String name, String columns) {
        logger.trace("primaryKey: " + name + ", columns" + columns);
        String[] array = this.splitValues(columns);
        return this.primaryKey(name, array);
    }

    public CreateTableBuilder primaryKey(String[] columns) {
        logger.trace("primaryKey: <unnamed>, columns" + Arrays.toString(columns));
        return this.primaryKey(null, columns);
    }

    public CreateTableBuilder primaryKey(String columns) {
        logger.trace("primaryKey: <unnamed>, columns" + columns);
        return this.primaryKey(null, this.splitValues(columns));
    }

    public CreateTableBuilder foreignKey(String name, String[] columns, String referencedTable, String[] referencedColumns) {
        logger.trace("foreignKey: " + name + ", columns" + Arrays.toString(columns) + ", referencedTable: " + referencedTable + ", referencedColumns: " + Arrays.toString(referencedColumns));
        CreateTableForeignKeyBuilder foreignKey = new CreateTableForeignKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            foreignKey.column(column);
        }
        foreignKey.referencedTable(referencedTable);
        for (String column : referencedColumns) {
            foreignKey.referencedColumn(column);
        }
        this.foreignKeys.add(foreignKey);
        return this;
    }

    public CreateTableBuilder foreignKey(String name, String columns, String referencedTable, String referencedColumns) {
        logger.trace("foreignKey: " + name + ", columns" + columns + ", referencedTable: " + referencedTable + ", referencedColumns: " + referencedColumns);
        return this.foreignKey(name, this.splitValues(columns), referencedTable, this.splitValues(referencedColumns));
    }

    public CreateTableBuilder unique(String name, String[] columns) {
        logger.trace("unique: " + name + ", columns" + Arrays.toString(columns));
        CreateTableUniqueIndexBuilder uniqueIndex = new CreateTableUniqueIndexBuilder(this.getDialect(), name);
        for (String column : columns) {
            uniqueIndex.column(column);
        }
        this.uniqueIndices.add(uniqueIndex);
        return this;
    }

    public CreateTableBuilder unique(String name, String columns) {
        logger.trace("unique: " + name + ", columns" + columns);
        return this.unique(name, this.splitValues(columns));
    }

    public CreateTableBuilder check(String name, String expression) {
        logger.trace("check: " + name + ", expression" + expression);
        CreateTableCheckBuilder check = new CreateTableCheckBuilder(this.getDialect(), name);
        check.expression(expression);
        this.checks.add(check);
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateTable(sql);
        sql.append(" ").append("(");
        this.generateColumns(sql);
        this.generatePrimaryKey(sql);
        this.generateForeignKeys(sql);
        this.generateUniqueIndices(sql);
        this.generateChecks(sql);
        sql.append(")");
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        sql.append(" ").append("TABLE").append(" ").append(this.table);
    }

    protected void generateColumns(StringBuilder sql) {
        if (!this.columns.isEmpty()) {
            sql.append(this.traverseColumns());
        }
    }

    protected void generatePrimaryKey(StringBuilder sql) {
        if (this.primaryKey != null) {
            sql.append(",").append(" ");
            if (this.primaryKey.getName() != null) {
                sql.append("CONSTRAINT").append(" ").append(this.primaryKey.getName()).append(" ");
            }
            sql.append("PRIMARY").append(" ").append("KEY").append(" ").append("(").append(this.traverseColumnNames(this.primaryKey.getColumns())).append(")");
        }
    }

    protected void generateForeignKeys(StringBuilder sql) {
        for (CreateTableForeignKeyBuilder foreignKey : this.foreignKeys) {
            this.generateForeignKey(sql, foreignKey);
        }
    }

    protected void generateForeignKey(StringBuilder sql, CreateTableForeignKeyBuilder foreignKey) {
        if (foreignKey != null) {
            sql.append(",").append(" ");
            if (foreignKey.getName() != null) {
                sql.append("CONSTRAINT").append(" ").append(foreignKey.getName()).append(" ");
            }
            sql.append("FOREIGN").append(" ").append("KEY").append(" ").append("(").append(this.traverseColumnNames(foreignKey.getColumns())).append(")").append(" ").append("REFERENCES").append(" ").append(foreignKey.getReferencedTable()).append("(").append(this.traverseColumnNames(foreignKey.getReferencedColumns())).append(")");
        }
    }

    protected void generateUniqueIndices(StringBuilder sql) {
        for (CreateTableUniqueIndexBuilder uniqueIndex : this.uniqueIndices) {
            this.generateUniqueIndex(sql, uniqueIndex);
        }
    }

    protected void generateUniqueIndex(StringBuilder sql, CreateTableUniqueIndexBuilder uniqueIndex) {
        if (uniqueIndex != null) {
            sql.append(",").append(" ");
            if (uniqueIndex.getName() != null) {
                sql.append("CONSTRAINT").append(" ").append(uniqueIndex.getName()).append(" ");
            }
            sql.append("UNIQUE").append(" ").append("(").append(this.traverseColumnNames(uniqueIndex.getColumns())).append(")");
        }
    }

    protected void generateChecks(StringBuilder sql) {
        for (CreateTableCheckBuilder index : this.checks) {
            this.generateCheck(sql, index);
        }
    }

    protected void generateCheck(StringBuilder sql, CreateTableCheckBuilder check) {
        if (check != null) {
            sql.append(",").append(" ");
            if (check.getName() != null) {
                sql.append("CONSTRAINT").append(" ").append(check.getName()).append(" ");
            }
            sql.append("CHECK").append(" ").append("(").append(check.getExpression()).append(")");
        }
    }

    protected String traverseColumns() {
        StringBuilder snippet = new StringBuilder();
        snippet.append(" ");
        for (String[] column : this.columns) {
            for (String arg : column) {
                snippet.append(arg).append(" ");
            }
            snippet.append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String traverseColumnNames(Set<String> columns) {
        StringBuilder snippet = new StringBuilder();
        snippet.append(" ");
        for (String column : columns) {
            snippet.append(column).append(" ").append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    private String[] splitValues(String columns) {
        String[] array = new String[]{};
        if (columns != null) {
            array = columns.split(",");
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }
}

