/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.ISqlKeywords;
import org.eclipse.dirigible.database.sql.SqlException;
import org.eclipse.dirigible.database.sql.builders.CreateBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.DropBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.ExpressionBuilder;
import org.eclipse.dirigible.database.sql.builders.records.DeleteBuilder;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.eclipse.dirigible.database.sql.builders.records.SelectBuilder;
import org.eclipse.dirigible.database.sql.builders.records.UpdateBuilder;
import org.eclipse.dirigible.database.sql.builders.sequence.LastValueIdentityBuilder;
import org.eclipse.dirigible.database.sql.builders.sequence.NextValueSequenceBuilder;

public class DefaultSqlDialect<SELECT extends SelectBuilder, INSERT extends InsertBuilder, UPDATE extends UpdateBuilder, DELETE extends DeleteBuilder, CREATE extends CreateBranchingBuilder, DROP extends DropBranchingBuilder, NEXT extends NextValueSequenceBuilder, LAST extends LastValueIdentityBuilder>
implements ISqlDialect<SELECT, INSERT, UPDATE, DELETE, CREATE, DROP, NEXT, LAST> {
    @Override
    public SELECT select() {
        return (SELECT)new SelectBuilder(this);
    }

    @Override
    public INSERT insert() {
        return (INSERT)new InsertBuilder(this);
    }

    @Override
    public UPDATE update() {
        return (UPDATE)new UpdateBuilder(this);
    }

    @Override
    public DELETE delete() {
        return (DELETE)new DeleteBuilder(this);
    }

    @Override
    public ExpressionBuilder expression() {
        return new ExpressionBuilder(this);
    }

    @Override
    public CREATE create() {
        return (CREATE)new CreateBranchingBuilder(this);
    }

    @Override
    public DROP drop() {
        return (DROP)new DropBranchingBuilder(this);
    }

    @Override
    public NEXT nextval(String sequence) {
        return (NEXT)new NextValueSequenceBuilder(this, sequence);
    }

    @Override
    public String getDataTypeName(DataType dataType) {
        return dataType.toString();
    }

    @Override
    public String getPrimaryKeyArgument() {
        return "PRIMARY KEY";
    }

    @Override
    public String getIdentityArgument() {
        return "IDENTITY";
    }

    @Override
    public String getNotNullArgument() {
        return "NOT NULL";
    }

    @Override
    public String getUniqueArgument() {
        return "UNIQUE";
    }

    @Override
    public boolean exists(Connection connection, String table) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, null, table, ISqlKeywords.METADATA_TABLE_TYPES.toArray(new String[0]));
        return resultSet.next();
    }

    @Override
    public int count(Connection connection, String table) throws SQLException {
        String sql = new SelectBuilder(this).column("COUNT(*)").from(table).build();
        PreparedStatement statement = connection.prepareStatement(sql);
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        throw new SQLException("Cannot calculate the count of records of table: " + table);
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public boolean isCatalogForSchema() {
        return false;
    }

    @Override
    public String functionCurrentDate() {
        return "CURRENT_DATE";
    }

    @Override
    public String functionCurrentTime() {
        return "CURRENT_TIME";
    }

    @Override
    public String functionCurrentTimestamp() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public LAST lastval(String ... args) {
        return (LAST)new LastValueIdentityBuilder(this);
    }

    @Override
    public boolean isSequenceSupported() {
        return true;
    }

    @Override
    public String getDatabaseName(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            throw new SqlException("Cannot retrieve the database name", e);
        }
    }
}

