/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.database.sql.ISqlKeywords;
import org.eclipse.dirigible.database.sql.builders.records.DeleteBuilder;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.eclipse.dirigible.database.sql.builders.records.SelectBuilder;
import org.eclipse.dirigible.database.sql.builders.records.UpdateBuilder;
import org.eclipse.dirigible.database.sql.dialects.DefaultSqlDialect;
import org.eclipse.dirigible.database.sql.dialects.mysql.MySQLCreateBranchingBuilder;
import org.eclipse.dirigible.database.sql.dialects.mysql.MySQLDropBranchingBuilder;
import org.eclipse.dirigible.database.sql.dialects.mysql.MySQLLastValueIdentityBuilder;
import org.eclipse.dirigible.database.sql.dialects.mysql.MySQLNextValueSequenceBuilder;

public class MySQLSqlDialect
extends DefaultSqlDialect<SelectBuilder, InsertBuilder, UpdateBuilder, DeleteBuilder, MySQLCreateBranchingBuilder, MySQLDropBranchingBuilder, MySQLNextValueSequenceBuilder, MySQLLastValueIdentityBuilder> {
    private static final String MYSQL_KEYWORD_IDENTITY = "AUTO_INCREMENT";

    @Override
    public MySQLCreateBranchingBuilder create() {
        return new MySQLCreateBranchingBuilder(this);
    }

    @Override
    public MySQLDropBranchingBuilder drop() {
        return new MySQLDropBranchingBuilder(this);
    }

    @Override
    public MySQLNextValueSequenceBuilder nextval(String sequence) {
        return new MySQLNextValueSequenceBuilder(this, sequence);
    }

    @Override
    public MySQLLastValueIdentityBuilder lastval(String ... args) {
        return new MySQLLastValueIdentityBuilder(this);
    }

    @Override
    public String getIdentityArgument() {
        return MYSQL_KEYWORD_IDENTITY;
    }

    @Override
    public boolean isSequenceSupported() {
        return false;
    }

    @Override
    public boolean exists(Connection connection, String table) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, null, table.toUpperCase(), ISqlKeywords.METADATA_TABLE_TYPES.toArray(new String[0]));
        return resultSet.next();
    }
}

