/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlKeywords;
import org.eclipse.dirigible.database.sql.builders.DropBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.records.DeleteBuilder;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.eclipse.dirigible.database.sql.builders.records.SelectBuilder;
import org.eclipse.dirigible.database.sql.builders.records.UpdateBuilder;
import org.eclipse.dirigible.database.sql.builders.sequence.LastValueIdentityBuilder;
import org.eclipse.dirigible.database.sql.dialects.DefaultSqlDialect;
import org.eclipse.dirigible.database.sql.dialects.postgres.PostgresCreateBranchingBuilder;
import org.eclipse.dirigible.database.sql.dialects.postgres.PostgresNextValueSequenceBuilder;

public class PostgresSqlDialect
extends DefaultSqlDialect<SelectBuilder, InsertBuilder, UpdateBuilder, DeleteBuilder, PostgresCreateBranchingBuilder, DropBranchingBuilder, PostgresNextValueSequenceBuilder, LastValueIdentityBuilder> {
    public static final String FUNCTION_CURRENT_DATE = "current_date";
    public static final String FUNCTION_CURRENT_TIME = "current_time";
    public static final String FUNCTION_CURRENT_TIMESTAMP = "current_timestamp";

    @Override
    public PostgresCreateBranchingBuilder create() {
        return new PostgresCreateBranchingBuilder(this);
    }

    @Override
    public PostgresNextValueSequenceBuilder nextval(String sequence) {
        return new PostgresNextValueSequenceBuilder(this, sequence);
    }

    @Override
    public String functionCurrentDate() {
        return FUNCTION_CURRENT_DATE;
    }

    @Override
    public String functionCurrentTime() {
        return FUNCTION_CURRENT_TIME;
    }

    @Override
    public String functionCurrentTimestamp() {
        return FUNCTION_CURRENT_TIMESTAMP;
    }

    @Override
    public String getDataTypeName(DataType dataType) {
        switch (dataType) {
            case BLOB: {
                return "bytea";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
        }
        return super.getDataTypeName(dataType);
    }

    @Override
    public boolean exists(Connection connection, String table) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, null, table.toLowerCase(), ISqlKeywords.METADATA_TABLE_TYPES.toArray(new String[0]));
        return resultSet.next();
    }
}

