/*
 * Copyright (c) ${license.git.copyrightYears} SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-FileCopyrightText: ${license.git.copyrightYears} SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.Set;
import java.util.TreeSet;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Abstract Create Table Constraint Builder.
 *
 * @param <CONSTRAINT>
 *            the generic type
 */
public abstract class AbstractCreateTableConstraintBuilder<CONSTRAINT extends AbstractCreateTableConstraintBuilder> extends AbstractSqlBuilder {

	private static final Logger logger = LoggerFactory.getLogger(AbstractCreateTableConstraintBuilder.class);

	private String name;

	private Set<String> modifiers = new TreeSet<String>();

	private Set<String> columns = new TreeSet<String>();

	/**
	 * Instantiates a new abstract create table constraint builder.
	 *
	 * @param dialect
	 *            the dialect
	 * @param name
	 *            the name
	 */
	AbstractCreateTableConstraintBuilder(ISqlDialect dialect, String name) {
		super(dialect);
		this.name = name;
	}

	/**
	 * Gets the name.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Gets the modifiers.
	 *
	 * @return the modifiers
	 */
	public Set<String> getModifiers() {
		return modifiers;
	}

	/**
	 * Gets the columns.
	 *
	 * @return the columns
	 */
	public Set<String> getColumns() {
		return columns;
	}

	/**
	 * Modifier.
	 *
	 * @param modifier
	 *            the modifier
	 * @return the constraint
	 */
	public CONSTRAINT modifier(String modifier) {
		this.modifiers.add(modifier);
		return (CONSTRAINT) this;
	}

	/**
	 * Column.
	 *
	 * @param column
	 *            the column
	 * @return the constraint
	 */
	public CONSTRAINT column(String column) {
		logger.trace("column: " + column);
		this.columns.add(column);
		return (CONSTRAINT) this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.dirigible.database.sql.ISqlBuilder#generate()
	 */
	@Override
	public String generate() {
		throw new IllegalStateException("Direct use of generate on the constraint level is not needed.");
	}

}
