/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.SqlException;

public class DataTypeUtils {
    public static final int VARCHAR_DEFAULT_LENGTH = 512;
    private static final Map<Integer, DataType> DATABASE_TYPE_TO_DATA_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Integer> STRING_TO_DATABASE_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<Class, Integer> JAVA_TYPE_TO_DATABASE_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<Integer, Class> DATABASE_TYPE_TO_JAVA_TYPE = Collections.synchronizedMap(new HashMap());

    public static boolean isDatabaseTypeSupported(Integer type) {
        return DATABASE_TYPE_TO_DATA_TYPE.containsKey(type);
    }

    public static DataType getDatabaseType(Integer type) {
        if (DataTypeUtils.isDatabaseTypeSupported(type)) {
            return DATABASE_TYPE_TO_DATA_TYPE.get(type);
        }
        throw new SqlException(MessageFormat.format("Type {0} not supported", type));
    }

    public static String getDatabaseTypeName(Integer type) {
        if (DataTypeUtils.isDatabaseTypeSupported(type)) {
            return DATABASE_TYPE_TO_DATA_TYPE.get(type).toString();
        }
        throw new SqlException(MessageFormat.format("Type {0} not supported", type));
    }

    public static Integer getDatabaseTypeByJavaType(Class clazz) {
        Integer type = JAVA_TYPE_TO_DATABASE_TYPE.get(clazz);
        if (type == null) {
            for (Map.Entry<Class, Integer> entry : JAVA_TYPE_TO_DATABASE_TYPE.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
            throw new SqlException(MessageFormat.format("Class {0} does not have mapping to a data type", clazz));
        }
        return type;
    }

    public static Class getJavaTypeByDatabaseType(Integer type) {
        Class clazz = DATABASE_TYPE_TO_JAVA_TYPE.get(type);
        if (clazz == null) {
            throw new SqlException(MessageFormat.format("Type {0} does not have mapping to a java type", type));
        }
        return clazz;
    }

    public static Integer getSqlTypeByDataType(String type) {
        if (STRING_TO_DATABASE_TYPE.containsKey(type = type.toUpperCase())) {
            return STRING_TO_DATABASE_TYPE.get(type);
        }
        throw new SqlException(MessageFormat.format("Type {0} not supported", type));
    }

    public static String getDatabaseTypeNameByJavaType(Class clazz) {
        Integer type = DataTypeUtils.getDatabaseTypeByJavaType(clazz);
        return DataTypeUtils.getDatabaseTypeName(type);
    }

    public static boolean isBlob(String dataType) {
        return DataType.BLOB.toString().equals(dataType);
    }

    public static boolean isBoolean(String dataType) {
        return DataType.BOOLEAN.toString().equals(dataType);
    }

    public static boolean isDouble(String dataType) {
        return DataType.DOUBLE.toString().equals(dataType);
    }

    public static boolean isReal(String dataType) {
        return DataType.REAL.toString().equals(dataType);
    }

    public static boolean isFloat(String dataType) {
        return DataType.FLOAT.toString().equals(dataType);
    }

    public static boolean isBigint(String dataType) {
        return DataType.BIGINT.toString().equals(dataType);
    }

    public static boolean isSmallint(String dataType) {
        return DataType.SMALLINT.toString().equals(dataType);
    }

    public static boolean isInteger(String dataType) {
        return DataType.INTEGER.toString().equals(dataType);
    }

    public static boolean isTinyint(String dataType) {
        return DataType.TINYINT.toString().equals(dataType);
    }

    public static boolean isTimestamp(String dataType) {
        return DataType.TIMESTAMP.toString().equals(dataType);
    }

    public static boolean isTime(String dataType) {
        return DataType.TIME.toString().equals(dataType);
    }

    public static boolean isDate(String dataType) {
        return DataType.DATE.toString().equals(dataType);
    }

    public static boolean isChar(String dataType) {
        return DataType.CHAR.toString().equals(dataType);
    }

    public static boolean isVarchar(String dataType) {
        return DataType.VARCHAR.toString().equals(dataType);
    }

    public static boolean isNvarchar(String dataType) {
        return DataType.NVARCHAR.toString().equals(dataType);
    }

    public static boolean isDecimal(String dataType) {
        return DataType.DECIMAL.toString().equals(dataType);
    }

    public static boolean isBit(String dataType) {
        return DataType.BIT.toString().equals(dataType);
    }

    static {
        DATABASE_TYPE_TO_DATA_TYPE.put(12, DataType.VARCHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(-9, DataType.NVARCHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(1, DataType.CHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(93, DataType.TIMESTAMP);
        DATABASE_TYPE_TO_DATA_TYPE.put(92, DataType.TIME);
        DATABASE_TYPE_TO_DATA_TYPE.put(4, DataType.INTEGER);
        DATABASE_TYPE_TO_DATA_TYPE.put(-5, DataType.BIGINT);
        DATABASE_TYPE_TO_DATA_TYPE.put(5, DataType.SMALLINT);
        DATABASE_TYPE_TO_DATA_TYPE.put(7, DataType.REAL);
        DATABASE_TYPE_TO_DATA_TYPE.put(6, DataType.FLOAT);
        DATABASE_TYPE_TO_DATA_TYPE.put(8, DataType.DOUBLE);
        DATABASE_TYPE_TO_DATA_TYPE.put(91, DataType.DATE);
        DATABASE_TYPE_TO_DATA_TYPE.put(16, DataType.BOOLEAN);
        DATABASE_TYPE_TO_DATA_TYPE.put(2004, DataType.BLOB);
        DATABASE_TYPE_TO_DATA_TYPE.put(3, DataType.DECIMAL);
        DATABASE_TYPE_TO_DATA_TYPE.put(-7, DataType.BIT);
        STRING_TO_DATABASE_TYPE.put("VARCHAR", 12);
        STRING_TO_DATABASE_TYPE.put("NVARCHAR", -9);
        STRING_TO_DATABASE_TYPE.put("CHAR", 1);
        STRING_TO_DATABASE_TYPE.put("TIMESTAMP", 93);
        STRING_TO_DATABASE_TYPE.put("TIME", 92);
        STRING_TO_DATABASE_TYPE.put("INTEGER", 4);
        STRING_TO_DATABASE_TYPE.put("BIGINT", -5);
        STRING_TO_DATABASE_TYPE.put("SMALLINT", 5);
        STRING_TO_DATABASE_TYPE.put("REAL", 7);
        STRING_TO_DATABASE_TYPE.put("FLOAT", 6);
        STRING_TO_DATABASE_TYPE.put("DOUBLE", 8);
        STRING_TO_DATABASE_TYPE.put("DATE", 91);
        STRING_TO_DATABASE_TYPE.put("BOOLEAN", 16);
        STRING_TO_DATABASE_TYPE.put("BLOB", 2004);
        STRING_TO_DATABASE_TYPE.put("DECIMAL", 3);
        STRING_TO_DATABASE_TYPE.put("BIT", -7);
        JAVA_TYPE_TO_DATABASE_TYPE.put(String.class, 12);
        JAVA_TYPE_TO_DATABASE_TYPE.put(String.class, -9);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Integer.class, 4);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Integer.TYPE, 4);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Long.class, -5);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Long.TYPE, -5);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Float.class, 6);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Float.TYPE, 6);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Double.class, 8);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Double.TYPE, 8);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Boolean.class, 16);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Boolean.TYPE, 16);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Date.class, 93);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Time.class, 92);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Timestamp.class, 93);
        JAVA_TYPE_TO_DATABASE_TYPE.put(byte[].class, 2004);
        DATABASE_TYPE_TO_JAVA_TYPE.put(12, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-9, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(1, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(93, Timestamp.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(92, Time.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(5, Integer.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(4, Integer.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-5, Long.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(7, Float.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(6, Float.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(8, Double.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(3, Double.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(91, Date.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(16, Boolean.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(2004, byte[].class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(3, Double.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-7, Boolean.TYPE);
    }
}

