/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.records;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertBuilder
extends AbstractSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(InsertBuilder.class);
    private String table = null;
    private List<String> columns = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();
    private String select = null;

    public InsertBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public InsertBuilder into(String table) {
        logger.trace("into: " + table);
        this.table = table;
        return this;
    }

    public InsertBuilder column(String name) {
        logger.trace("column: " + name);
        this.columns.add(name);
        return this;
    }

    public InsertBuilder value(String value) {
        logger.trace("value: " + value);
        this.values.add(value);
        return this;
    }

    public InsertBuilder select(String select) {
        logger.trace("select: " + select);
        this.select = select;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateInsert(sql);
        this.generateTable(sql);
        this.generateColumns(sql);
        this.generateValues(sql);
        this.generateSelect(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        String tableName = this.isCaseSensitive() ? this.encapsulate(this.getTable()) : this.getTable();
        sql.append(" ").append("INTO").append(" ").append(tableName);
    }

    protected void generateColumns(StringBuilder sql) {
        if (!this.columns.isEmpty()) {
            sql.append(" ").append("(").append(this.traverseColumns()).append(")");
        }
    }

    protected void generateValues(StringBuilder sql) {
        if (!this.values.isEmpty()) {
            sql.append(" ").append("VALUES").append(" ").append("(").append(this.traverseValues()).append(")");
        } else if (!this.columns.isEmpty() && this.select == null) {
            sql.append(" ").append("VALUES").append(" ").append("(").append(this.enumerateValues()).append(")");
        }
    }

    protected void generateSelect(StringBuilder sql) {
        if (this.select != null) {
            sql.append(" ").append(this.select);
        }
    }

    protected String traverseColumns() {
        StringBuilder snippet = new StringBuilder();
        for (String column : this.columns) {
            String columnName = this.isCaseSensitive() ? this.encapsulate(column) : column;
            snippet.append(columnName).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String traverseValues() {
        StringBuilder snippet = new StringBuilder();
        for (String value : this.values) {
            snippet.append(value).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected String enumerateValues() {
        StringBuilder snippet = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            snippet.append("?").append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected void generateInsert(StringBuilder sql) {
        sql.append("INSERT");
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getSelect() {
        return this.select;
    }
}

