/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableBuilder<TABLE_BUILDER extends AbstractTableBuilder>
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableBuilder.class);
    private String table;
    private List<String[]> columns = new ArrayList<String[]>();

    public AbstractTableBuilder(ISqlDialect dialect, String table) {
        super(dialect);
        this.table = table;
    }

    protected String getTable() {
        return this.table;
    }

    protected List<String[]> getColumns() {
        return this.columns;
    }

    public TABLE_BUILDER column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        logger.trace("column: " + name + ", type: " + (type != null ? type.name() : null) + ", isPrimaryKey: " + isPrimaryKey + ", isNullable: " + isNullable + ", isUnique: " + isUnique + ", isIdentity: " + isIdentity + ", args: " + Arrays.toString(args));
        String[] definition = new String[]{name, this.getDialect().getDataTypeName(type)};
        String[] column = isIdentity != false ? (String[])Stream.of(definition, args, {this.getDialect().getIdentityArgument()}).flatMap(Stream::of).toArray(String[]::new) : (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        if (!isNullable.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getNotNullArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        if (isPrimaryKey.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getPrimaryKeyArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        if (isUnique.booleanValue() && !isPrimaryKey.booleanValue()) {
            column = (String[])Stream.of(column, {this.getDialect().getUniqueArgument()}).flatMap(Stream::of).toArray(String[]::new);
        }
        this.columns.add(column);
        return (TABLE_BUILDER)this;
    }

    public TABLE_BUILDER column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, type, isPrimaryKey, isNullable, isUnique, false, args);
    }

    public TABLE_BUILDER column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, type, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER column(String name, DataType type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, type, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, DataType type, Boolean isPrimaryKey) {
        return this.column(name, type, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, DataType type) {
        return this.column(name, type, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER column(String name, int type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, int type, Boolean isPrimaryKey) {
        return this.column(name, DataType.values()[type], isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, int type) {
        return this.column(name, DataType.values()[type], (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, int type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.values()[type], isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, Double type, Boolean isPrimaryKey) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, Double type) {
        return this.column(name, DataType.values()[type.intValue()], (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, Double type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.values()[type.intValue()], isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER column(String name, String type, Boolean isPrimaryKey, Boolean isNullable) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, String type, Boolean isPrimaryKey) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, String type) {
        return this.column(name, DataType.valueOf(type), (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER column(String name, String type, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.column(name, DataType.valueOf(type), isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + length + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.VARCHAR, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, new String[0]);
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, isUnique, false);
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnVarchar(name, length, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnVarchar(String name, int length, Boolean isPrimaryKey) {
        return this.columnVarchar(name, length, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnVarchar(String name, int length) {
        return this.columnVarchar(name, length, false);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + length + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.NVARCHAR, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnNvarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity) {
        return this.columnNvarchar(name, length, isPrimaryKey, isNullable, isUnique, isIdentity, new String[0]);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnNvarchar(name, length, isPrimaryKey, isNullable, isUnique, false);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnNvarchar(name, length, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length, Boolean isPrimaryKey) {
        return this.columnNvarchar(name, length, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnNvarchar(String name, int length) {
        return this.columnNvarchar(name, length, false);
    }

    public TABLE_BUILDER columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + length + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.CHAR, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public TABLE_BUILDER columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, isUnique, false, this.splitValues(args));
    }

    public TABLE_BUILDER columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, isUnique, false, new String[0]);
    }

    public TABLE_BUILDER columnChar(String name, int length, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnChar(name, length, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnChar(String name, int length, Boolean isPrimaryKey) {
        return this.columnChar(name, length, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnChar(String name, int length) {
        return this.columnChar(name, length, false);
    }

    public TABLE_BUILDER columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.DATE, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnDate(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnDate(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDate(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnDate(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDate(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDate(String name, Boolean isPrimaryKey) {
        return this.columnDate(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDate(String name) {
        return this.columnDate(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TIME, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTime(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnTime(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTime(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnTime(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTime(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTime(String name, Boolean isPrimaryKey) {
        return this.columnTime(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTime(String name) {
        return this.columnTime(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TIMESTAMP, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnTimestamp(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTimestamp(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTimestamp(String name, Boolean isPrimaryKey) {
        return this.columnTimestamp(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTimestamp(String name) {
        return this.columnTimestamp(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        return this.column(name, DataType.INTEGER, isPrimaryKey, isNullable, isUnique, isIdentity, args);
    }

    public TABLE_BUILDER columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnInteger(name, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public TABLE_BUILDER columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnInteger(name, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnInteger(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnInteger(name, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnInteger(String name, Boolean isPrimaryKey) {
        return this.columnInteger(name, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnInteger(String name) {
        return this.columnInteger(name, false);
    }

    public TABLE_BUILDER columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.TINYINT, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnTinyint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnTinyint(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTinyint(String name, Boolean isPrimaryKey) {
        return this.columnTinyint(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnTinyint(String name) {
        return this.columnTinyint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        return this.column(name, DataType.BIGINT, isPrimaryKey, isNullable, isUnique, isIdentity, args);
    }

    public TABLE_BUILDER columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnBigint(name, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public TABLE_BUILDER columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnBigint(name, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBigint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnBigint(name, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnBigint(String name, Boolean isPrimaryKey) {
        return this.columnBigint(name, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnBigint(String name) {
        return this.columnBigint(name, false);
    }

    public TABLE_BUILDER columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.SMALLINT, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnSmallint(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnSmallint(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnSmallint(String name, Boolean isPrimaryKey) {
        return this.columnSmallint(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnSmallint(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.REAL, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnReal(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnReal(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnReal(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnReal(String name, Boolean isPrimaryKey) {
        return this.columnReal(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnReal(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnFloat(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.FLOAT, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnFloat(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnFloat(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnReal(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnFloat(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnReal(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnFloat(String name, Boolean isPrimaryKey) {
        return this.columnReal(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnFloat(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.DOUBLE, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnDouble(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDouble(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnDouble(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDouble(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDouble(String name, Boolean isPrimaryKey) {
        return this.columnDouble(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDouble(String name) {
        return this.columnSmallint(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String ... args) {
        return this.column(name, DataType.BOOLEAN, isPrimaryKey, isNullable, isUnique, args);
    }

    public TABLE_BUILDER columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, String args) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, isUnique, this.splitValues(args));
    }

    public TABLE_BUILDER columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, isUnique, new String[0]);
    }

    public TABLE_BUILDER columnBoolean(String name, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnBoolean(name, isPrimaryKey, isNullable, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBoolean(String name, Boolean isPrimaryKey) {
        return this.columnBoolean(name, isPrimaryKey, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBoolean(String name) {
        return this.columnBoolean(name, (Boolean)false, (Boolean)true, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnBlob(String name, Boolean isNullable, String ... args) {
        return this.column(name, DataType.BLOB, (Boolean)false, isNullable, (Boolean)false, args);
    }

    public TABLE_BUILDER columnBlob(String name, Boolean isNullable, String args) {
        return this.columnBlob(name, isNullable, this.splitValues(args));
    }

    public TABLE_BUILDER columnBlob(String name, Boolean isNullable) {
        return this.columnBlob(name, isNullable, new String[0]);
    }

    public TABLE_BUILDER columnBlob(String name) {
        return this.columnBlob(name, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String ... args) {
        String[] definition = new String[]{"(" + precision + "," + scale + ")"};
        String[] coulmn = (String[])Stream.of(definition, args).flatMap(Stream::of).toArray(String[]::new);
        return this.column(name, DataType.DECIMAL, isPrimaryKey, isNullable, isUnique, isIdentity, coulmn);
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique, Boolean isIdentity, String args) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, isUnique, isIdentity, this.splitValues(args));
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable, Boolean isUnique) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, isUnique, (Boolean)false, new String[0]);
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey, Boolean isNullable) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, isNullable, false);
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale, Boolean isPrimaryKey) {
        return this.columnDecimal(name, precision, scale, isPrimaryKey, true);
    }

    public TABLE_BUILDER columnDecimal(String name, int precision, int scale) {
        return this.columnDecimal(name, precision, scale, false);
    }

    public TABLE_BUILDER columnBit(String name, Boolean isNullable, String ... args) {
        return this.column(name, DataType.BIT, (Boolean)false, isNullable, (Boolean)false, args);
    }

    public TABLE_BUILDER columnBit(String name, Boolean isNullable, String args) {
        return this.columnBit(name, isNullable, this.splitValues(args));
    }

    public TABLE_BUILDER columnBit(String name, Boolean isNullable) {
        return this.columnBit(name, isNullable, new String[0]);
    }

    public TABLE_BUILDER columnBit(String name) {
        return this.columnBit(name, (Boolean)false, new String[0]);
    }

    protected void generateTable(StringBuilder sql) {
        String tableName = this.isCaseSensitive() ? this.encapsulate(this.getTable()) : this.getTable();
        sql.append(" ").append("TABLE").append(" ").append(tableName);
    }

    protected void generateColumns(StringBuilder sql) {
        if (!this.getColumns().isEmpty()) {
            sql.append(this.traverseColumns());
        }
    }

    protected void generateColumnNamesForDrop(StringBuilder sql) {
        if (!this.getColumns().isEmpty()) {
            sql.append(this.traverseColumnNamesForDrop());
        }
    }

    protected String traverseColumns() {
        StringBuilder snippet = new StringBuilder();
        snippet.append(" ");
        List allPrimaryKeys = this.columns.stream().filter(el -> Arrays.stream(el).anyMatch(x -> x.equals(this.getDialect().getPrimaryKeyArgument()))).collect(Collectors.toList());
        boolean isCompositeKey = allPrimaryKeys.size() > 1;
        for (String[] column : this.columns) {
            boolean first = true;
            for (String arg : column) {
                if (first) {
                    String columnName = this.isCaseSensitive() ? this.encapsulate(arg) : arg;
                    snippet.append(columnName).append(" ");
                    first = false;
                    continue;
                }
                if (isCompositeKey && arg.equals(this.getDialect().getPrimaryKeyArgument())) continue;
                snippet.append(arg).append(" ");
            }
            snippet.append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String traverseColumnNamesForDrop() {
        StringBuilder snippet = new StringBuilder();
        for (String[] column : this.columns) {
            String columnName = this.isCaseSensitive() ? this.encapsulate(column[0]) : column[0];
            snippet.append("DROP").append(" ").append("COLUMN").append(" ");
            snippet.append(columnName).append(" ");
            snippet.append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String traverseNames(Set<String> names) {
        StringBuilder snippet = new StringBuilder();
        snippet.append(" ");
        for (String column : names) {
            String columnName = this.isCaseSensitive() ? this.encapsulate(column) : column;
            snippet.append(columnName).append(" ").append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String[] splitValues(String columns) {
        String[] array = new String[]{};
        if (columns != null) {
            array = columns.split(",");
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }
}

