/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.table.AbstractTableBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableForeignKeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableBuilder
extends AbstractTableBuilder<AlterTableBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(AlterTableBuilder.class);
    private String action = null;
    private List<CreateTableForeignKeyBuilder> foreignKeys = new ArrayList<CreateTableForeignKeyBuilder>();

    public AlterTableBuilder(ISqlDialect dialect, String table) {
        super(dialect, table);
    }

    public AlterTableBuilder add() {
        this.action = "ADD";
        return this;
    }

    public AlterTableBuilder drop() {
        this.action = "DROP";
        return this;
    }

    protected String getAction() {
        return this.action;
    }

    public List<CreateTableForeignKeyBuilder> getForeignKeys() {
        return this.foreignKeys;
    }

    public AlterTableBuilder foreignKey(String name, String[] columns, String referencedTable, String[] referencedColumns) {
        logger.trace("foreignKey: " + name + ", columns" + Arrays.toString(columns) + ", referencedTable: " + referencedTable + ", referencedColumns: " + Arrays.toString(referencedColumns));
        CreateTableForeignKeyBuilder foreignKey = new CreateTableForeignKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            foreignKey.column(column);
        }
        foreignKey.referencedTable(referencedTable);
        for (String column : referencedColumns) {
            foreignKey.referencedColumn(column);
        }
        this.foreignKeys.add(foreignKey);
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateAlter(sql);
        this.generateTable(sql);
        sql.append(" ");
        if ("ADD".equals(this.action)) {
            sql.append("ADD");
            if (!this.getColumns().isEmpty()) {
                this.generateColumns(sql);
            } else if (!this.getForeignKeys().isEmpty()) {
                this.generateForeignKeys(sql);
            }
        } else if ("DROP".equals(this.action)) {
            if (!this.getColumns().isEmpty()) {
                this.generateColumnNamesForDrop(sql);
            } else if (!this.getForeignKeys().isEmpty()) {
                this.generateForeignKeyNames(sql);
            }
        } else {
            logger.error("Action for alter table must be present and can be only ADD or DROP.");
        }
        String generated = sql.toString().trim();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateForeignKeys(StringBuilder sql) {
        for (CreateTableForeignKeyBuilder foreignKey : this.foreignKeys) {
            this.generateForeignKey(sql, foreignKey);
        }
    }

    protected void generateForeignKey(StringBuilder sql, CreateTableForeignKeyBuilder foreignKey) {
        if (foreignKey != null) {
            sql.append(" ");
            if (foreignKey.getName() != null) {
                String foreignKeyName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getName()) : foreignKey.getName();
                sql.append("CONSTRAINT").append(" ").append(foreignKeyName).append(" ");
            }
            String referencedTableName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getReferencedTable()) : foreignKey.getReferencedTable();
            sql.append("FOREIGN").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(foreignKey.getColumns())).append(")").append(" ").append("REFERENCES").append(" ").append(referencedTableName).append("(").append(this.traverseNames(foreignKey.getReferencedColumns())).append(")");
        }
    }

    private void generateForeignKeyNames(StringBuilder sql) {
        StringBuilder snippet = new StringBuilder();
        for (CreateTableForeignKeyBuilder foreignKey : this.foreignKeys) {
            String foreignKeyName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getName()) : foreignKey.getName();
            snippet.append("DROP").append(" ").append("CONSTRAINT").append(" ");
            snippet.append(foreignKeyName).append(" ");
            snippet.append(",").append(" ");
        }
        sql.append(snippet.toString().substring(0, snippet.length() - 2));
    }
}

