/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlException;
import org.eclipse.dirigible.database.sql.builders.table.AbstractTableBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableCheckBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableForeignKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTablePrimaryKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableUniqueIndexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableBuilder
extends AbstractTableBuilder<CreateTableBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableBuilder.class);
    private CreateTablePrimaryKeyBuilder primaryKey;
    private List<CreateTableForeignKeyBuilder> foreignKeys = new ArrayList<CreateTableForeignKeyBuilder>();
    private List<CreateTableUniqueIndexBuilder> uniqueIndices = new ArrayList<CreateTableUniqueIndexBuilder>();
    private List<CreateTableCheckBuilder> checks = new ArrayList<CreateTableCheckBuilder>();

    public CreateTableBuilder(ISqlDialect dialect, String table) {
        super(dialect, table);
    }

    public CreateTableBuilder primaryKey(String name, String[] columns) {
        logger.trace("primaryKey: " + name + ", columns" + Arrays.toString(columns));
        if (this.primaryKey != null) {
            throw new SqlException("Setting of primary key must be called only once");
        }
        this.primaryKey = new CreateTablePrimaryKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            this.primaryKey.column(column);
        }
        return this;
    }

    public CreateTableBuilder primaryKey(String name, String columns) {
        logger.trace("primaryKey: " + name + ", columns" + columns);
        String[] array = this.splitValues(columns);
        return this.primaryKey(name, array);
    }

    public CreateTableBuilder primaryKey(String[] columns) {
        logger.trace("primaryKey: <unnamed>, columns" + Arrays.toString(columns));
        return this.primaryKey(null, columns);
    }

    public CreateTableBuilder primaryKey(String columns) {
        logger.trace("primaryKey: <unnamed>, columns" + columns);
        return this.primaryKey(null, this.splitValues(columns));
    }

    public CreateTableBuilder foreignKey(String name, String[] columns, String referencedTable, String[] referencedColumns) {
        logger.trace("foreignKey: " + name + ", columns" + Arrays.toString(columns) + ", referencedTable: " + referencedTable + ", referencedColumns: " + Arrays.toString(referencedColumns));
        CreateTableForeignKeyBuilder foreignKey = new CreateTableForeignKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            foreignKey.column(column);
        }
        foreignKey.referencedTable(referencedTable);
        for (String column : referencedColumns) {
            foreignKey.referencedColumn(column);
        }
        this.foreignKeys.add(foreignKey);
        return this;
    }

    public CreateTableBuilder foreignKey(String name, String columns, String referencedTable, String referencedColumns) {
        logger.trace("foreignKey: " + name + ", columns" + columns + ", referencedTable: " + referencedTable + ", referencedColumns: " + referencedColumns);
        return this.foreignKey(name, this.splitValues(columns), referencedTable, this.splitValues(referencedColumns));
    }

    public CreateTableBuilder unique(String name, String[] columns) {
        logger.trace("unique: " + name + ", columns" + Arrays.toString(columns));
        CreateTableUniqueIndexBuilder uniqueIndex = new CreateTableUniqueIndexBuilder(this.getDialect(), name);
        for (String column : columns) {
            uniqueIndex.column(column);
        }
        this.uniqueIndices.add(uniqueIndex);
        return this;
    }

    public CreateTableBuilder unique(String name, String columns) {
        logger.trace("unique: " + name + ", columns" + columns);
        return this.unique(name, this.splitValues(columns));
    }

    public CreateTableBuilder check(String name, String expression) {
        logger.trace("check: " + name + ", expression" + expression);
        CreateTableCheckBuilder check = new CreateTableCheckBuilder(this.getDialect(), name);
        check.expression(expression);
        this.checks.add(check);
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateTable(sql);
        sql.append(" ").append("(");
        this.generateColumns(sql);
        this.generatePrimaryKey(sql);
        this.generateForeignKeys(sql);
        this.generateUniqueIndices(sql);
        this.generateChecks(sql);
        sql.append(")");
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generatePrimaryKey(StringBuilder sql) {
        boolean isCompositeKey;
        List<String[]> allPrimaryKeys = this.getColumns().stream().filter(el -> Arrays.stream(el).anyMatch(x -> x.equals(this.getDialect().getPrimaryKeyArgument()))).collect(Collectors.toList());
        boolean bl = isCompositeKey = allPrimaryKeys.size() > 1;
        if (this.primaryKey != null && allPrimaryKeys.size() == 0) {
            sql.append(",").append(" ");
            if (this.primaryKey.getName() != null) {
                String primaryKeyName = this.isCaseSensitive() ? this.encapsulate(this.primaryKey.getName()) : this.primaryKey.getName();
                sql.append("CONSTRAINT").append(" ").append(primaryKeyName).append(" ");
            }
            sql.append("PRIMARY").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(this.primaryKey.getColumns())).append(")");
        } else if (isCompositeKey) {
            sql.append(",").append(" ");
            ArrayList keys = new ArrayList();
            allPrimaryKeys.forEach(el -> keys.add(el[0]));
            sql.append("PRIMARY").append(" ").append("KEY").append("(").append(String.join((CharSequence)" , ", keys)).append(")").append(" ");
        }
    }

    protected void generateForeignKeys(StringBuilder sql) {
        for (CreateTableForeignKeyBuilder foreignKey : this.foreignKeys) {
            this.generateForeignKey(sql, foreignKey);
        }
    }

    protected void generateForeignKey(StringBuilder sql, CreateTableForeignKeyBuilder foreignKey) {
        if (foreignKey != null) {
            sql.append(",").append(" ");
            if (foreignKey.getName() != null) {
                String foreignKeyName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getName()) : foreignKey.getName();
                sql.append("CONSTRAINT").append(" ").append(foreignKeyName).append(" ");
            }
            String referencedTableName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getReferencedTable()) : foreignKey.getReferencedTable();
            sql.append("FOREIGN").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(foreignKey.getColumns())).append(")").append(" ").append("REFERENCES").append(" ").append(referencedTableName).append("(").append(this.traverseNames(foreignKey.getReferencedColumns())).append(")");
        }
    }

    protected void generateUniqueIndices(StringBuilder sql) {
        for (CreateTableUniqueIndexBuilder uniqueIndex : this.uniqueIndices) {
            this.generateUniqueIndex(sql, uniqueIndex);
        }
    }

    protected void generateUniqueIndex(StringBuilder sql, CreateTableUniqueIndexBuilder uniqueIndex) {
        if (uniqueIndex != null) {
            sql.append(",").append(" ");
            if (uniqueIndex.getName() != null) {
                String uniqueIndexName = this.isCaseSensitive() ? this.encapsulate(uniqueIndex.getName()) : uniqueIndex.getName();
                sql.append("CONSTRAINT").append(" ").append(uniqueIndexName).append(" ");
            }
            sql.append("UNIQUE").append(" ").append("(").append(this.traverseNames(uniqueIndex.getColumns())).append(")");
        }
    }

    protected void generateChecks(StringBuilder sql) {
        for (CreateTableCheckBuilder index : this.checks) {
            this.generateCheck(sql, index);
        }
    }

    protected void generateCheck(StringBuilder sql, CreateTableCheckBuilder check) {
        if (check != null) {
            sql.append(",").append(" ");
            if (check.getName() != null) {
                String checkName = this.isCaseSensitive() ? this.encapsulate(check.getName()) : check.getName();
                sql.append("CONSTRAINT").append(" ").append(checkName).append(" ");
            }
            sql.append("CHECK").append(" ").append("(").append(check.getExpression()).append(")");
        }
    }
}

