/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropConstraintBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropConstraintBuilder.class);
    private String constraint = null;
    private String table = null;

    public DropConstraintBuilder(ISqlDialect dialect, String constraint) {
        super(dialect);
        this.constraint = constraint;
    }

    public DropConstraintBuilder fromTable(String table) {
        this.table = table;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateAlter(sql);
        this.generateDrop(sql);
        this.generateConstraint(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateAlter(StringBuilder sql) {
        String tableName = this.isCaseSensitive() ? this.encapsulate(this.getTable()) : this.getTable();
        sql.append("ALTER").append(" ").append("TABLE").append(" ").append(tableName).append(" ");
    }

    protected void generateConstraint(StringBuilder sql) {
        String constraintName = this.isCaseSensitive() ? this.encapsulate(this.getConstraint()) : this.getConstraint();
        sql.append(" ").append("CONSTRAINT").append(" ").append(constraintName);
    }

    public String getConstraint() {
        return this.constraint;
    }
}

