/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropTableBuilder.class);
    private String table = null;

    public DropTableBuilder(ISqlDialect dialect, String table) {
        super(dialect);
        this.table = table;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateTable(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        String tableName = this.isCaseSensitive() ? this.encapsulate(this.getTable()) : this.getTable();
        sql.append(" ").append("TABLE").append(" ").append(tableName);
    }

    public String getTable() {
        return this.table;
    }
}

