/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.dialects.derby.DerbySqlDialect;
import org.eclipse.dirigible.database.sql.dialects.h2.H2SqlDialect;
import org.eclipse.dirigible.database.sql.dialects.hana.HanaSqlDialect;
import org.eclipse.dirigible.database.sql.dialects.mysql.MySQLSqlDialect;
import org.eclipse.dirigible.database.sql.dialects.postgres.PostgresSqlDialect;
import org.eclipse.dirigible.database.sql.dialects.sybase.SybaseSqlDialect;

public class SqlDialectFactory {
    public static final ISqlDialect DATABASE_TYPE_DERBY = new DerbySqlDialect();
    public static final ISqlDialect DATABASE_TYPE_H2 = new H2SqlDialect();
    public static final ISqlDialect DATABASE_TYPE_MYSQL = new MySQLSqlDialect();
    public static final ISqlDialect DATABASE_TYPE_POSTGRES = new PostgresSqlDialect();
    public static final ISqlDialect DATABASE_TYPE_HANA = new HanaSqlDialect();
    public static final ISqlDialect DATABASE_TYPE_SYBASE = new SybaseSqlDialect();
    protected static final Map<String, ISqlDialect> databaseTypeMappings = SqlDialectFactory.getDefaultDatabaseTypeMappings();

    public static final ISqlDialect getDialect(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return databaseTypeMappings.get(productName);
    }

    protected static Map<String, ISqlDialect> getDefaultDatabaseTypeMappings() {
        Map<String, ISqlDialect> databaseTypeMappings = Collections.synchronizedMap(new HashMap());
        databaseTypeMappings.put("Apache Derby", DATABASE_TYPE_DERBY);
        databaseTypeMappings.put("H2", DATABASE_TYPE_H2);
        databaseTypeMappings.put("PostgreSQL", DATABASE_TYPE_POSTGRES);
        databaseTypeMappings.put("HDB", DATABASE_TYPE_HANA);
        databaseTypeMappings.put("Adaptive Server Enterprise", DATABASE_TYPE_SYBASE);
        databaseTypeMappings.put("MySQL", DATABASE_TYPE_MYSQL);
        return databaseTypeMappings;
    }
}

