/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects.derby;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.view.CreateViewBuilder;

public class DerbyCreateViewBuilder
extends CreateViewBuilder {
    private String values = null;

    public DerbyCreateViewBuilder(ISqlDialect dialect, String view) {
        super(dialect, view);
    }

    @Override
    public DerbyCreateViewBuilder column(String name) {
        super.getColumns().add(name);
        return this;
    }

    @Override
    public DerbyCreateViewBuilder asSelect(String select) {
        if (this.values != null) {
            throw new IllegalStateException("Create VIEW can use either AS SELECT or AS VALUES, but not both.");
        }
        this.setSelect(select);
        return this;
    }

    public DerbyCreateViewBuilder asValues(String values) {
        if (this.getSelect() != null) {
            throw new IllegalStateException("Create VIEW can use either AS SELECT or AS VALUES, but not both.");
        }
        this.values = values;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateView(sql);
        this.generateColumns(sql);
        if (this.getSelect() != null) {
            this.generateAsSelect(sql);
        } else if (this.values != null) {
            this.generateAsValues(sql);
        } else {
            throw new IllegalStateException("Create VIEW must use either AS SELECT or AS VALUES.");
        }
        return sql.toString();
    }

    protected void generateAsValues(StringBuilder sql) {
        sql.append(" ").append("AS").append(" ").append("VALUES").append(" ").append(this.values);
    }
}

