/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects.hana;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.sequence.DropSequenceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaDropSequenceBuilder
extends DropSequenceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HanaDropSequenceBuilder.class);

    public HanaDropSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect, sequence);
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateSequence(sql);
        this.generateRestrict(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateRestrict(StringBuilder sql) {
        String sequenceName = this.isCaseSensitive() ? this.encapsulate(this.getSequence()) : this.getSequence();
        sql.append(" ").append("RESTRICT");
    }
}

