/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.sql.ISqlBuilder;
import org.eclipse.dirigible.database.sql.ISqlDialect;

public abstract class AbstractSqlBuilder
implements ISqlBuilder {
    private ISqlDialect dialect;
    private Pattern columnPattern = Pattern.compile("^(?![0-9]*$)[a-zA-Z0-9_#$]+$");
    private Pattern contentBetweenSingleQuotes = Pattern.compile("'([^']*?)'");
    private Pattern numericPattern = Pattern.compile("-?\\d+(\\.\\d+)?");

    protected AbstractSqlBuilder(ISqlDialect dialect) {
        this.dialect = dialect;
    }

    protected ISqlDialect getDialect() {
        return this.dialect;
    }

    public String toString() {
        return this.build();
    }

    @Override
    public String build() {
        return this.generate();
    }

    protected boolean isCaseSensitive() {
        return Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
    }

    protected String encapsulate(String name) {
        return this.encapsulate(name, false);
    }

    protected String encapsulate(String name, boolean isDataStructureName) {
        String escapeSymbol = this.getEscapeSymbol();
        if ("*".equals(((String)name).trim())) {
            return name;
        }
        if (!((String)name).startsWith(escapeSymbol)) {
            name = isDataStructureName || this.isColumn(((String)name).trim()) ? escapeSymbol + (String)name + escapeSymbol : this.encapsulateMany((String)name);
        }
        return name;
    }

    public String getEscapeSymbol() {
        return this.getDialect().getEscapeSymbol();
    }

    protected boolean isColumn(String name) {
        if (name == null) {
            return false;
        }
        return this.columnPattern.matcher(name).matches();
    }

    protected String encapsulateMany(String line) {
        String lineWithoughContentBetweenSingleQuotes = String.join((CharSequence)"", line.split(this.contentBetweenSingleQuotes.toString()));
        String regex = "([^a-zA-Z0-9_#$::']+)'*\\1*";
        String[] words = lineWithoughContentBetweenSingleQuotes.split(regex);
        Set<String> functionsNames = this.getDialect().getFunctionsNames();
        for (String word : words) {
            if (this.isNumeric(word) || this.isValue(word) || "".equals(word.trim()) || functionsNames.contains(word.toLowerCase())) continue;
            line = line.replace(word, "\"" + word + "\"");
        }
        return line;
    }

    protected boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        return this.numericPattern.matcher(s).matches();
    }

    protected boolean isValue(String s) {
        if (s == null) {
            return false;
        }
        return s.startsWith("'") || s.endsWith("'");
    }
}

