/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.sequence;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSequenceBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateSequenceBuilder.class);
    private String sequence;
    private Integer start;
    private Integer increment;
    private Integer maxvalue;
    private Boolean nomaxvalue;
    private Integer minvalue;
    private Boolean nominvalue;
    private Boolean cycles;
    private String resetBy;
    private Boolean publicc;

    public CreateSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect);
        this.sequence = sequence;
    }

    public String getSequence() {
        return this.sequence;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getIncrement() {
        return this.increment;
    }

    public CreateSequenceBuilder start(Integer start) {
        if (logger.isTraceEnabled()) {
            logger.trace("start: " + start);
        }
        this.start = start;
        return this;
    }

    public CreateSequenceBuilder increment(int increment) {
        if (logger.isTraceEnabled()) {
            logger.trace("increment: " + increment);
        }
        this.increment = increment;
        return this;
    }

    public CreateSequenceBuilder maxvalue(Integer maxvalue) {
        if (logger.isTraceEnabled()) {
            logger.trace("maxvalue: " + maxvalue);
        }
        this.maxvalue = maxvalue;
        return this;
    }

    public CreateSequenceBuilder nomaxvalue(Boolean nomaxvalue) {
        if (logger.isTraceEnabled()) {
            logger.trace("nomaxvalue: " + nomaxvalue);
        }
        this.nomaxvalue = nomaxvalue;
        return this;
    }

    public CreateSequenceBuilder minvalue(Integer minvalue) {
        if (logger.isTraceEnabled()) {
            logger.trace("minvalue: " + minvalue);
        }
        this.minvalue = minvalue;
        return this;
    }

    public CreateSequenceBuilder nominvalue(Boolean nominvalue) {
        if (logger.isTraceEnabled()) {
            logger.trace("nominvalue: " + nominvalue);
        }
        this.nominvalue = nominvalue;
        return this;
    }

    public CreateSequenceBuilder cycles(Boolean cycles) {
        if (logger.isTraceEnabled()) {
            logger.trace("cycles: " + cycles);
        }
        this.cycles = cycles;
        return this;
    }

    public CreateSequenceBuilder resetBy(String resetBy) {
        if (logger.isTraceEnabled()) {
            logger.trace("resetBy: " + resetBy);
        }
        this.resetBy = resetBy;
        return this;
    }

    public CreateSequenceBuilder publicc(Boolean publicc) {
        if (logger.isTraceEnabled()) {
            logger.trace("public: " + publicc);
        }
        this.publicc = publicc;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateSequence(sql);
        this.generateStart(sql);
        this.generateIncrement(sql);
        this.generateMaxvalue(sql);
        this.generateNomaxvalue(sql);
        this.generateMinvalue(sql);
        this.generateNominvalue(sql);
        this.generateCycle(sql);
        this.generateResetBy(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSequence(StringBuilder sql) {
        String sequenceName = this.isCaseSensitive() ? this.encapsulate(this.sequence, true) : this.sequence;
        sql.append(" ").append("SEQUENCE").append(" ").append(sequenceName);
    }

    protected void generateStart(StringBuilder sql) {
        if (this.start != null) {
            this.generateSequenceParameter(sql, "START WITH", String.valueOf(this.start));
        }
    }

    protected void generateIncrement(StringBuilder sql) {
        if (this.increment != null) {
            this.generateSequenceParameter(sql, "INCREMENT BY", String.valueOf(this.increment));
        }
    }

    protected void generateMaxvalue(StringBuilder sql) {
        if (this.maxvalue != null) {
            this.generateSequenceParameter(sql, "MAXVALUE", String.valueOf(this.maxvalue));
        }
    }

    protected void generateNomaxvalue(StringBuilder sql) {
        if (this.nomaxvalue != null && this.nomaxvalue.booleanValue()) {
            this.generateSequenceParameter(sql, "NO MAXVALUE", "");
        }
    }

    protected void generateMinvalue(StringBuilder sql) {
        if (this.minvalue != null) {
            this.generateSequenceParameter(sql, "MINVALUE", String.valueOf(this.minvalue));
        }
    }

    protected void generateNominvalue(StringBuilder sql) {
        if (this.nominvalue != null && this.nominvalue.booleanValue()) {
            this.generateSequenceParameter(sql, "NO MINVALUE", "");
        }
    }

    protected void generateCycle(StringBuilder sql) {
        if (this.cycles != null && this.cycles.booleanValue()) {
            this.generateSequenceParameter(sql, "CYCLE", "");
        }
    }

    protected void generateResetBy(StringBuilder sql) {
        if (this.resetBy != null) {
            this.generateSequenceParameter(sql, "RESET BY", String.valueOf(this.resetBy));
        }
    }

    protected void generateSequenceParameter(StringBuilder sql, String parameterName, String parameterValue) {
        sql.append(" ").append(parameterName).append(" ").append(parameterValue);
    }
}

