/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.synonym;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropSynonymBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropSynonymBuilder.class);
    private String synonym = null;

    public DropSynonymBuilder(ISqlDialect dialect, String synonym) {
        super(dialect);
        this.synonym = synonym;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateSynonym(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSynonym(StringBuilder sql) {
        String synonymName = this.isCaseSensitive() ? this.encapsulate(this.getSynonym(), true) : this.getSynonym();
        sql.append(" ").append("SYNONYM").append(" ").append(synonymName);
    }

    public String getSynonym() {
        return this.synonym;
    }
}

