/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.table.AbstractCreateTableConstraintBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableForeignKeyBuilder
extends AbstractCreateTableConstraintBuilder<CreateTableForeignKeyBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableForeignKeyBuilder.class);
    private String referencedTable;
    private String referencedTableSchema;
    private Set<String> referencedColumns = new TreeSet<String>();

    CreateTableForeignKeyBuilder(ISqlDialect dialect, String name) {
        super(dialect, name);
    }

    public String getReferencedTable() {
        return this.referencedTable;
    }

    public Set<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    public CreateTableForeignKeyBuilder referencedTable(String referencedTable) {
        if (logger.isTraceEnabled()) {
            logger.trace("referencedTable: " + referencedTable);
        }
        this.referencedTable = referencedTable;
        return this;
    }

    public CreateTableForeignKeyBuilder referencedColumn(String referencedColumn) {
        if (logger.isTraceEnabled()) {
            logger.trace("referencedColumn: " + referencedColumn);
        }
        this.referencedColumns.add(referencedColumn);
        return this;
    }

    public String getReferencedTableSchema() {
        return this.referencedTableSchema;
    }

    public CreateTableForeignKeyBuilder referencedTableSchema(String referencedTableSchema) {
        if (logger.isTraceEnabled()) {
            logger.trace("setReferencedTableSchema: " + referencedTableSchema);
        }
        this.referencedTableSchema = referencedTableSchema;
        return this;
    }
}

