/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.ISqlKeywords;
import org.eclipse.dirigible.database.sql.SqlException;
import org.eclipse.dirigible.database.sql.builders.AlterBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.CreateBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.DropBranchingBuilder;
import org.eclipse.dirigible.database.sql.builders.ExpressionBuilder;
import org.eclipse.dirigible.database.sql.builders.records.DeleteBuilder;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.eclipse.dirigible.database.sql.builders.records.SelectBuilder;
import org.eclipse.dirigible.database.sql.builders.records.UpdateBuilder;
import org.eclipse.dirigible.database.sql.builders.sequence.LastValueIdentityBuilder;
import org.eclipse.dirigible.database.sql.builders.sequence.NextValueSequenceBuilder;

public class DefaultSqlDialect<SELECT extends SelectBuilder, INSERT extends InsertBuilder, UPDATE extends UpdateBuilder, DELETE extends DeleteBuilder, CREATE extends CreateBranchingBuilder, ALTER extends AlterBranchingBuilder, DROP extends DropBranchingBuilder, NEXT extends NextValueSequenceBuilder, LAST extends LastValueIdentityBuilder>
implements ISqlDialect<SELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, DROP, NEXT, LAST> {
    public static final Set<String> FUNCTIONS = Collections.synchronizedSet(new HashSet<String>(Arrays.asList("ascii", "char_length", "character_length", "concat", "concat_ws", "field", "find_in_set", "format", "insert", "instr", "lcase", "left", "length", "locate", "lower", "lpad", "ltrim", "mid", "position", "repeat", "replace", "reverse", "right", "rpad", "rtrim", "space", "strcmp", "substr", "substring", "substring_index", "trim", "ucase", "upper", "abs", "acos", "asin", "atan", "atan2", "avg", "ceil", "ceiling", "cos", "cot", "count", "degrees", "div", "exp", "floor", "greatest", "least", "ln", "log", "log10", "log2", "max", "min", "mod", "pi", "pow", "power", "radians", "rand", "round", "sign", "sin", "sqrt", "sum", "tan", "truncate", "adddate", "addtime", "curdate", "current_date", "current_time", "current_timestamp", "curtime", "date", "datediff", "date_add", "date_format", "date_sub", "day", "dayname", "dayofmonth", "dayofweek", "dayofyear", "extract", "from_days", "hour", "last_day", "localtime", "localtimestamp", "makedate", "maketime", "microsecond", "minute", "month", "monthname", "now", "period_add", "period_diff", "quarter", "second", "sec_to_time", "str_to_date", "subdate", "subtime", "sysdate", "time", "time_format", "time_to_sec", "timediff", "timestamp", "to_days", "week", "weekday", "weekofyear", "year", "yearweek", "bin", "binary", "case", "cast", "coalesce", "connection_id", "conv", "convert", "current_user", "database", "if", "ifnull", "isnull", "last_insert_id", "nullif", "session_user", "system_user", "user", "version", "and", "or", "between", "binary", "case", "div", "in", "is", "not", "null", "like", "rlike", "xor")));

    @Override
    public SELECT select() {
        return (SELECT)new SelectBuilder(this);
    }

    @Override
    public INSERT insert() {
        return (INSERT)new InsertBuilder(this);
    }

    @Override
    public UPDATE update() {
        return (UPDATE)new UpdateBuilder(this);
    }

    @Override
    public DELETE delete() {
        return (DELETE)new DeleteBuilder(this);
    }

    @Override
    public ExpressionBuilder expression() {
        return new ExpressionBuilder(this);
    }

    @Override
    public CREATE create() {
        return (CREATE)new CreateBranchingBuilder(this);
    }

    @Override
    public ALTER alter() {
        return (ALTER)new AlterBranchingBuilder(this);
    }

    @Override
    public DROP drop() {
        return (DROP)new DropBranchingBuilder(this);
    }

    @Override
    public NEXT nextval(String sequence) {
        return (NEXT)new NextValueSequenceBuilder(this, sequence);
    }

    @Override
    public String getDataTypeName(DataType dataType) {
        return dataType.toString();
    }

    @Override
    public String getPrimaryKeyArgument() {
        return "PRIMARY KEY";
    }

    @Override
    public String getIdentityArgument() {
        return "IDENTITY";
    }

    @Override
    public String getNotNullArgument() {
        return "NOT NULL";
    }

    @Override
    public String getUniqueArgument() {
        return "UNIQUE";
    }

    @Override
    public boolean exists(Connection connection, String table) throws SQLException {
        return this.exists(connection, table, 1);
    }

    @Override
    public boolean exists(Connection connection, String table, int type) throws SQLException {
        return this.exists(connection, null, table, type);
    }

    @Override
    public boolean exists(Connection connection, String schema, String table, int type) throws SQLException {
        table = DefaultSqlDialect.normalizeTableName(table);
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, schema, DefaultSqlDialect.normalizeTableName(table), ISqlKeywords.METADATA_TABLE_TYPES.toArray(new String[0]));
        return resultSet.next();
    }

    public static String normalizeTableName(String table) {
        if (table != null && table.startsWith("\"") && table.endsWith("\"")) {
            table = table.substring(1, table.length() - 1);
        }
        return table;
    }

    @Override
    public int count(Connection connection, String table) throws SQLException {
        String sql = new SelectBuilder(this).column("COUNT(*)").from(table).build();
        PreparedStatement statement = connection.prepareStatement(sql);
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        throw new SQLException("Cannot calculate the count of records of table: " + table);
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public boolean isCatalogForSchema() {
        return false;
    }

    @Override
    public String functionCurrentDate() {
        return "CURRENT_DATE";
    }

    @Override
    public String functionCurrentTime() {
        return "CURRENT_TIME";
    }

    @Override
    public String functionCurrentTimestamp() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public LAST lastval(String ... args) {
        return (LAST)new LastValueIdentityBuilder(this);
    }

    @Override
    public boolean isSequenceSupported() {
        return true;
    }

    @Override
    public String getDatabaseName(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            throw new SqlException("Cannot retrieve the database name", e);
        }
    }

    @Override
    public boolean isSynonymSupported() {
        return true;
    }

    @Override
    public Set<String> getFunctionsNames() {
        return FUNCTIONS;
    }

    @Override
    public String getFuzzySearchIndex() {
        return " ";
    }

    @Override
    public String getEscapeSymbol() {
        return "\"";
    }
}

