/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractSqlBuilder;

public class ExpressionBuilder
extends AbstractSqlBuilder {
    private List<String> expressions = new ArrayList<String>();

    public ExpressionBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public ExpressionBuilder and(String name) {
        if (this.expressions.isEmpty()) {
            this.expressions.add(name);
        } else {
            this.expressions.add("AND " + name);
        }
        return this;
    }

    public ExpressionBuilder or(String name) {
        if (this.expressions.isEmpty()) {
            this.expressions.add(name);
        } else {
            this.expressions.add("OR " + name);
        }
        return this;
    }

    @Override
    public String generate() {
        return this.generateExpressions();
    }

    protected String generateExpressions() {
        StringBuilder snippet = new StringBuilder();
        for (String expression : this.expressions) {
            snippet.append(expression).append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 1);
    }

    public List<String> getExpressions() {
        return this.expressions;
    }
}

