/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.sequence;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractQuerySqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextValueSequenceBuilder
extends AbstractQuerySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(NextValueSequenceBuilder.class);
    private String sequence = null;

    public NextValueSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect);
        this.sequence = sequence;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateSelect(sql);
        this.generateNextValue(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSelect(StringBuilder sql) {
        sql.append("SELECT");
    }

    protected void generateNextValue(StringBuilder sql) {
        String sequenceName = this.isCaseSensitive() ? this.encapsulate(this.getSequence(), true) : this.getSequence();
        sql.append(" ").append("NEXT VALUE FOR").append(" ").append(sequenceName);
    }

    public String getSequence() {
        return this.sequence;
    }
}

