/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.table.AbstractTableBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableForeignKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableUniqueIndexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableBuilder
extends AbstractTableBuilder<AlterTableBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(AlterTableBuilder.class);
    private String action = null;
    private List<CreateTableForeignKeyBuilder> foreignKeys = new ArrayList<CreateTableForeignKeyBuilder>();
    private List<CreateTableUniqueIndexBuilder> uniqueIndices = new ArrayList<CreateTableUniqueIndexBuilder>();

    public AlterTableBuilder(ISqlDialect dialect, String table) {
        super(dialect, table);
    }

    public AlterTableBuilder add() {
        this.action = "ADD";
        return this;
    }

    public AlterTableBuilder alter() {
        this.action = "ALTER";
        return this;
    }

    public AlterTableBuilder drop() {
        this.action = "DROP";
        return this;
    }

    protected String getAction() {
        return this.action;
    }

    public List<CreateTableForeignKeyBuilder> getForeignKeys() {
        return this.foreignKeys;
    }

    public List<CreateTableUniqueIndexBuilder> getUniqueIndices() {
        return this.uniqueIndices;
    }

    public AlterTableBuilder foreignKey(String name, String[] columns, String referencedTable, String[] referencedColumns) {
        if (logger.isTraceEnabled()) {
            logger.trace("foreignKey: " + name + ", columns" + Arrays.toString(columns) + ", referencedTable: " + referencedTable + ", referencedColumns: " + Arrays.toString(referencedColumns));
        }
        CreateTableForeignKeyBuilder foreignKey = new CreateTableForeignKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            foreignKey.column(column);
        }
        foreignKey.referencedTable(referencedTable);
        for (String column : referencedColumns) {
            foreignKey.referencedColumn(column);
        }
        this.foreignKeys.add(foreignKey);
        return this;
    }

    @Override
    public AlterTableBuilder unique(String name, String[] columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("unique: " + name + ", columns" + Arrays.toString(columns));
        }
        CreateTableUniqueIndexBuilder uniqueIndex = new CreateTableUniqueIndexBuilder(this.getDialect(), name);
        for (String column : columns) {
            uniqueIndex.column(column);
        }
        this.uniqueIndices.add(uniqueIndex);
        return this;
    }

    @Override
    public AlterTableBuilder unique(String name, String[] columns, String type, String order) {
        return this.unique(name, columns);
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateAlter(sql);
        this.generateTable(sql);
        sql.append(" ");
        if ("ADD".equals(this.action)) {
            sql.append("ADD");
            if (!this.getColumns().isEmpty()) {
                this.generateColumns(sql);
            }
            if (!this.getForeignKeys().isEmpty()) {
                this.generateForeignKeyNames(sql);
            }
            if (!this.getUniqueIndices().isEmpty()) {
                this.generateUniqueIndices(sql);
            }
        } else if ("DROP".equals(this.action)) {
            if (!this.getColumns().isEmpty()) {
                this.generateColumnNamesForDrop(sql);
            }
            if (!this.getForeignKeys().isEmpty()) {
                this.generateForeignKeyNamesForDrop(sql);
            }
            if (!this.getUniqueIndices().isEmpty()) {
                this.generateUniqueIndicesForDrop(sql);
            }
        } else if (!this.getColumns().isEmpty()) {
            sql.append("ALTER");
            this.generateColumnsForAlter(sql);
        }
        String generated = sql.append(";").toString().trim();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    private void generateForeignKeyNamesForDrop(StringBuilder sql) {
        if (!this.getForeignKeys().isEmpty()) {
            sql.append("DROP").append(" ").append("CONSTRAINT").append(" ");
            this.getForeignKeys().forEach(fk -> sql.append(fk.getName() + ", "));
            sql.delete(sql.length() - 2, sql.length());
        }
    }

    private void generateUniqueIndicesForDrop(StringBuilder sql) {
        if (!this.getUniqueIndices().isEmpty()) {
            sql.append("DROP").append(" ").append("CONSTRAINT").append(" ");
            this.getUniqueIndices().forEach(ui -> sql.append(ui.getName() + ", "));
            sql.delete(sql.length() - 2, sql.length());
        }
    }

    protected void generateForeignKeyNames(StringBuilder sql) {
        StringBuilder snippet = new StringBuilder();
        for (CreateTableForeignKeyBuilder foreignKey : this.getForeignKeys()) {
            snippet.append(" ").append("CONSTRAINT").append(" ").append(foreignKey.getName()).append(" ").append("FOREIGN").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(foreignKey.getColumns())).append(")").append(" ").append("REFERENCES").append(" ").append(foreignKey.getReferencedTable()).append(" ").append("(").append(this.traverseNames(foreignKey.getReferencedColumns())).append(")").append(",").append(" ");
        }
        sql.append(snippet.substring(0, snippet.length() - 2));
    }

    protected void generateUniqueIndices(StringBuilder sql) {
        for (CreateTableUniqueIndexBuilder uniqueIndex : this.uniqueIndices) {
            this.generateUniqueIndex(sql, uniqueIndex);
            sql.append(",");
        }
    }

    protected void generateUniqueIndex(StringBuilder sql, CreateTableUniqueIndexBuilder uniqueIndex) {
        if (uniqueIndex != null) {
            if (uniqueIndex.getName() != null) {
                String uniqueIndexName = this.isCaseSensitive() ? this.encapsulate(uniqueIndex.getName()) : uniqueIndex.getName();
                sql.append("CONSTRAINT").append(" ").append(uniqueIndexName).append(" ");
            }
            sql.append("UNIQUE").append(" ").append("(").append(this.traverseNames(uniqueIndex.getColumns())).append(")");
        }
    }
}

