/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateViewBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateViewBuilder.class);
    private String view = null;
    private List<String> columns = new ArrayList<String>();
    private String select = null;

    public CreateViewBuilder(ISqlDialect dialect, String view) {
        super(dialect);
        this.view = view;
    }

    protected String getView() {
        return this.view;
    }

    protected List<String> getColumns() {
        return this.columns;
    }

    protected String getSelect() {
        return this.select;
    }

    protected void setSelect(String select) {
        if (logger.isTraceEnabled()) {
            logger.trace("setSelect: " + select);
        }
        this.select = select;
    }

    public CreateViewBuilder column(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("column: " + name);
        }
        this.columns.add(name);
        return this;
    }

    public CreateViewBuilder asSelect(String select) {
        if (logger.isTraceEnabled()) {
            logger.trace("asSelect: " + select);
        }
        this.select = select;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateView(sql);
        this.generateColumns(sql);
        this.generateAsSelect(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateView(StringBuilder sql) {
        String viewName = this.isCaseSensitive() ? this.encapsulate(this.getView(), true) : this.getView();
        sql.append(" ").append("VIEW").append(" ").append(viewName);
    }

    protected void generateColumns(StringBuilder sql) {
        if (!this.columns.isEmpty()) {
            sql.append(" ").append("(").append(this.traverseColumns()).append(")");
        }
    }

    protected String traverseColumns() {
        StringBuilder snippet = new StringBuilder();
        snippet.append(" ");
        for (String column : this.columns) {
            String columnName = this.isCaseSensitive() ? this.encapsulate(column) : column;
            snippet.append(columnName).append(" ");
            snippet.append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    protected void generateAsSelect(StringBuilder sql) {
        sql.append(" ").append("AS").append(" ").append(this.select);
    }
}

