/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.ISqlDialectProvider;

public class SqlDialectFactory {
    private static final ServiceLoader<ISqlDialectProvider> SQL_PROVIDERS = ServiceLoader.load(ISqlDialectProvider.class);
    protected static final Map<String, ISqlDialect> databaseTypeMappings = SqlDialectFactory.getDefaultDatabaseTypeMappings();

    public static final ISqlDialect getDialect(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return databaseTypeMappings.get(productName);
    }

    protected static Map<String, ISqlDialect> getDefaultDatabaseTypeMappings() {
        Map<String, ISqlDialect> databaseTypeMappings = Collections.synchronizedMap(new HashMap());
        for (ISqlDialectProvider next : SQL_PROVIDERS) {
            databaseTypeMappings.put(next.getName(), next.getDialect());
        }
        return databaseTypeMappings;
    }
}

