/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.dirigible.commons.api.module.StaticInjector;
import org.eclipse.dirigible.engine.api.IEngineExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineExecutorFactory {
    private static final ServiceLoader<IEngineExecutor> ENGINE_EXECUTORS = ServiceLoader.load(IEngineExecutor.class);
    private static final Logger logger = LoggerFactory.getLogger(EngineExecutorFactory.class);

    public static IEngineExecutor getEngineExecutor(String type) {
        for (IEngineExecutor next : ENGINE_EXECUTORS) {
            if (!next.getType().equals(type)) continue;
            return (IEngineExecutor)StaticInjector.getInjector().getInstance(next.getClass());
        }
        logger.error(MessageFormat.format("Executor of Type {0} does not exist.", type));
        return null;
    }

    public static Set<String> getEnginesTypes() {
        HashSet<String> engineTypes = new HashSet<String>();
        for (IEngineExecutor next : ENGINE_EXECUTORS) {
            engineTypes.add(next.getType());
        }
        return engineTypes;
    }

    public static Set<String> getEnginesNames() {
        HashSet<String> engineTypes = new HashSet<String>();
        for (IEngineExecutor next : ENGINE_EXECUTORS) {
            engineTypes.add(next.getName());
        }
        return engineTypes;
    }
}

