/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.engine.api.resource.IResourceExecutor;
import org.eclipse.dirigible.engine.api.script.AbstractScriptExecutor;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceExecutor
implements IResourceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceExecutor.class);
    @Inject
    private IRepository repository;

    protected IRepository getRepository() {
        return this.repository;
    }

    @Override
    public byte[] getResourceContent(String root, String module) throws RepositoryException {
        return this.getResourceContent(root, module, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getResourceContent(String root, String module, String extension) throws RepositoryException {
        if (module == null) throw new RepositoryException("Module name cannot be empty or null.");
        if ("".equals(module.trim())) {
            throw new RepositoryException("Module name cannot be empty or null.");
        }
        if (module.trim().endsWith("/")) {
            throw new RepositoryException("Module name cannot point to a collection.");
        }
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.repository.getResource(repositoryPath);
        if (resource.exists()) {
            return resource.getContent();
        }
        try {
            String location = "/" + module + (extension != null ? extension : "");
            try (InputStream bundled = AbstractScriptExecutor.class.getResourceAsStream(location);){
                if (bundled != null) {
                    byte[] byArray = IOUtils.toByteArray((InputStream)bundled);
                    return byArray;
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        String logMsg = String.format("There is no resource at the specified path: %s", repositoryPath);
        logger.error(logMsg);
        throw new RepositoryNotFoundException(logMsg);
    }

    @Override
    public ICollection getCollection(String root, String module) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module);
        ICollection collection = this.repository.getCollection(repositoryPath);
        if (collection.exists()) {
            return collection;
        }
        String logMsg = String.format("There is no collection [%s] at the specified Service path: %s", collection.getName(), repositoryPath);
        logger.error(logMsg);
        throw new RepositoryException(logMsg);
    }

    @Override
    public IResource getResource(String root, String module) throws RepositoryException {
        return this.getResource(root, module, null);
    }

    @Override
    public IResource getResource(String root, String module, String extension) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.repository.getResource(repositoryPath);
        if (resource.exists()) {
            return resource;
        }
        String logMsg = String.format("There is no collection [%s] at the specified path: %s", resource.getName(), repositoryPath);
        logger.error(logMsg);
        throw new RepositoryException(logMsg);
    }

    @Override
    public boolean existResource(String root, String module) throws RepositoryException {
        return this.existResource(root, module, null);
    }

    @Override
    public boolean existResource(String root, String module, String extension) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.repository.getResource(repositoryPath);
        return resource.exists();
    }

    @Override
    public String createResourcePath(String root, String module) {
        return this.createResourcePath(root, module, null);
    }

    @Override
    public String createResourcePath(String root, String module, String extension) {
        StringBuilder buff = new StringBuilder().append(root).append("/").append(module);
        if (extension != null) {
            buff.append(extension);
        }
        String resourcePath = buff.toString();
        return resourcePath;
    }
}

