/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.script;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.api.script.ScriptEngineExecutorFactory;

public class ScriptEngineExecutorsManager {
    public static Object executeServiceModule(String engineType, String module, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor(engineType);
        if (scriptEngineExecutor != null) {
            return scriptEngineExecutor.executeServiceModule(module, executionContext);
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the Module [{1}] cannot be processed", engineType, module));
    }

    public static Object executeServiceCode(String engineType, String code, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor(engineType);
        if (scriptEngineExecutor != null) {
            return scriptEngineExecutor.executeServiceCode(code, executionContext);
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the code [{1}] cannot be processed", engineType, code));
    }
}

