/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.script;

import java.io.InputStream;
import org.eclipse.dirigible.engine.api.resource.AbstractResourceExecutor;
import org.eclipse.dirigible.engine.api.resource.ResourcePath;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.api.script.Module;
import org.eclipse.dirigible.repository.api.RepositoryException;

public abstract class AbstractScriptExecutor
extends AbstractResourceExecutor
implements IScriptEngineExecutor {
    @Override
    public Module retrieveModule(String root, String module) throws RepositoryException {
        return this.retrieveModule(root, module, null);
    }

    @Override
    public Module retrieveModule(String root, String module, String extension) throws RepositoryException {
        String resourcePath = this.createResourcePath(root, module, extension);
        return new Module(resourcePath, this.getResourceContent(root, module, extension));
    }

    protected ResourcePath getResourcePath(String module, String ... moduleExtensions) {
        return AbstractScriptExecutor.generateResourcePath(module, moduleExtensions);
    }

    public static ResourcePath generateResourcePath(String module, String[] moduleExtensions) {
        for (String moduleExtension : moduleExtensions) {
            if (module.indexOf(moduleExtension) <= 0) continue;
            ResourcePath resourcePath = new ResourcePath();
            String modulePath = module.substring(0, module.indexOf(moduleExtension) + moduleExtension.length() - 1);
            resourcePath.setModule(modulePath);
            if (module.length() > modulePath.length()) {
                resourcePath.setPath(module.substring(modulePath.length() + 1));
            } else {
                resourcePath.setPath("");
            }
            return resourcePath;
        }
        return new ResourcePath(module, "");
    }

    @Override
    public boolean existsModule(String root, String module) throws RepositoryException {
        return this.existsModule(root, module, null);
    }

    @Override
    public boolean existsModule(String root, String module, String extension) throws RepositoryException {
        if (super.existResource(root, module, extension)) {
            return true;
        }
        String ext = extension != null ? extension : "";
        InputStream bundled = AbstractScriptExecutor.class.getResourceAsStream("/" + module + ext);
        return bundled != null;
    }
}

