/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.commons.config.StaticObjects;
import org.eclipse.dirigible.engine.api.resource.IResourceExecutor;
import org.eclipse.dirigible.engine.api.script.AbstractScriptExecutor;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceExecutor
implements IResourceExecutor {
    private static final String LOCATION_META_INF_DIRIGIBLE = "/META-INF/dirigible";
    private static final String LOCATION_META_INF_WEBJARS = "/META-INF/resources/webjars";
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceExecutor.class);
    private IRepository repository = null;
    private static Map<String, byte[]> PREDELIVERED = Collections.synchronizedMap(new HashMap());

    protected IRepository getRepository() {
        if (this.repository == null) {
            this.repository = (IRepository)StaticObjects.get((String)"REPOSITORY");
        }
        return this.repository;
    }

    @Override
    public byte[] getResourceContent(String root, String module) throws RepositoryException {
        return this.getResourceContent(root, module, null);
    }

    @Override
    public byte[] getResourceContent(String root, String module, String extension) throws RepositoryException {
        byte[] result = null;
        if (module == null || "".equals(module.trim())) {
            throw new RepositoryException("Module name cannot be empty or null.");
        }
        if (module.trim().endsWith("/")) {
            throw new RepositoryException("Module name cannot point to a collection.");
        }
        result = this.tryFromRepositoryLocation(root, module, extension);
        if (result == null && (result = this.tryFromDirigibleLocation(module, extension)) == null) {
            result = this.tryFromWebJarsLocation(module, extension);
        }
        if (result != null) {
            return result;
        }
        String repositoryPath = this.createResourcePath(root, module, extension);
        String logMsg = String.format("There is no resource at the specified path: %s", repositoryPath);
        if (logger.isErrorEnabled()) {
            logger.error(logMsg);
        }
        throw new RepositoryNotFoundException(logMsg);
    }

    private byte[] tryFromRepositoryLocation(String root, String module, String extension) {
        byte[] result = null;
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.getRepository().getResource(repositoryPath);
        if (resource.exists()) {
            result = resource.getContent();
        }
        return result;
    }

    private byte[] tryFromDirigibleLocation(String module, String extension) {
        return this.tryFromClassloaderLocation(module, extension, LOCATION_META_INF_DIRIGIBLE);
    }

    private byte[] tryFromWebJarsLocation(String module, String extension) {
        return this.tryFromClassloaderLocation(module, extension, LOCATION_META_INF_WEBJARS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] tryFromClassloaderLocation(String module, String extension, String path) {
        byte[] result = null;
        try {
            String prefix = Character.toString(module.charAt(0)).equals("/") ? "" : "/";
            String location = prefix + module + (extension != null ? extension : "");
            byte[] content = PREDELIVERED.get(location);
            if (content != null) {
                return content;
            }
            try (InputStream bundled = AbstractScriptExecutor.class.getResourceAsStream(path + location);){
                if (bundled != null) {
                    content = IOUtils.toByteArray((InputStream)bundled);
                    PREDELIVERED.put(location, content);
                    result = content;
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return result;
    }

    @Override
    public ICollection getCollection(String root, String module) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module);
        ICollection collection = this.getRepository().getCollection(repositoryPath);
        if (collection.exists()) {
            return collection;
        }
        String logMsg = String.format("There is no collection [%s] at the specified Service path: %s", collection.getName(), repositoryPath);
        if (logger.isErrorEnabled()) {
            logger.error(logMsg);
        }
        throw new RepositoryException(logMsg);
    }

    @Override
    public IResource getResource(String root, String module) throws RepositoryException {
        return this.getResource(root, module, null);
    }

    @Override
    public IResource getResource(String root, String module, String extension) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.getRepository().getResource(repositoryPath);
        if (resource.exists()) {
            return resource;
        }
        String logMsg = String.format("There is no collection [%s] at the specified path: %s", resource.getName(), repositoryPath);
        if (logger.isErrorEnabled()) {
            logger.error(logMsg);
        }
        throw new RepositoryException(logMsg);
    }

    @Override
    public boolean existResource(String root, String module) throws RepositoryException {
        return this.existResource(root, module, null);
    }

    @Override
    public boolean existResource(String root, String module, String extension) throws RepositoryException {
        String repositoryPath = this.createResourcePath(root, module, extension);
        IResource resource = this.getRepository().getResource(repositoryPath);
        return resource.exists();
    }

    @Override
    public String createResourcePath(String root, String module) {
        return this.createResourcePath(root, module, null);
    }

    @Override
    public String createResourcePath(String root, String module, String extension) {
        StringBuilder buff = new StringBuilder().append(root);
        if (!Character.toString(module.charAt(0)).equals("/")) {
            buff.append("/");
        }
        buff.append(module);
        if (extension != null) {
            buff.append(extension);
        }
        String resourcePath = buff.toString();
        return resourcePath;
    }

    protected byte[] getLoadedPredeliveredContent(String location) {
        return PREDELIVERED.get(location);
    }
}

