/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.script;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineExecutorFactory {
    private static final ServiceLoader<IScriptEngineExecutor> SCRIPT_ENGINE_EXECUTORS = ServiceLoader.load(IScriptEngineExecutor.class);
    private static final Logger logger = LoggerFactory.getLogger(ScriptEngineExecutorFactory.class);

    public static IScriptEngineExecutor getScriptEngineExecutor(String type) {
        for (IScriptEngineExecutor next : SCRIPT_ENGINE_EXECUTORS) {
            if (!next.getType().equals(type)) continue;
            try {
                return (IScriptEngineExecutor)next.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error(MessageFormat.format("Script Executor of Type {0} does not exist.", type));
        }
        return null;
    }

    public static Set<String> getEnginesTypes() {
        HashSet<String> engineTypes = new HashSet<String>();
        for (IScriptEngineExecutor next : SCRIPT_ENGINE_EXECUTORS) {
            engineTypes.add(next.getType());
        }
        return engineTypes;
    }
}

