/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.api.script;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.dirigible.commons.api.context.ThreadContextFacade;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.api.script.ScriptEngineExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineExecutorsManager {
    private static final Logger logger = LoggerFactory.getLogger(ScriptEngineExecutorsManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeServiceModule(String engineType, String module, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor;
        if (engineType == null) {
            engineType = "javascript";
        }
        if ((scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor(engineType)) != null) {
            try {
                ThreadContextFacade.setUp();
                if (scriptEngineExecutor.existsModule("/registry/public", module)) {
                    Object object = scriptEngineExecutor.executeServiceModule(module, executionContext);
                    return object;
                }
                String notFound = MessageFormat.format("Script Module [{0}] does not exist, hence cannot be processed", module);
                if (logger.isErrorEnabled()) {
                    logger.error(notFound);
                }
                Object var5_6 = null;
                return var5_6;
            }
            finally {
                ThreadContextFacade.tearDown();
            }
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the Module [{1}] cannot be processed", engineType, module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evalModule(String code, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor("javascript");
        if (scriptEngineExecutor != null) {
            try {
                ThreadContextFacade.setUp();
                Object object = scriptEngineExecutor.evalModule(code, executionContext);
                return object;
            }
            finally {
                ThreadContextFacade.tearDown();
            }
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the Script [{1}] cannot be processed", "javascript", code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeServiceCode(String engineType, String code, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor(engineType);
        if (scriptEngineExecutor != null) {
            try {
                ThreadContextFacade.setUp();
                Object object = scriptEngineExecutor.evalCode(code, executionContext);
                return object;
            }
            finally {
                ThreadContextFacade.tearDown();
            }
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the code [{1}] cannot be processed", engineType, code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeMethodFromModule(String engineType, String module, String memberClass, String memberMethod, Map<Object, Object> executionContext) throws ScriptingException {
        IScriptEngineExecutor scriptEngineExecutor = ScriptEngineExecutorFactory.getScriptEngineExecutor(engineType);
        if (scriptEngineExecutor != null) {
            try {
                ThreadContextFacade.setUp();
                Object object = scriptEngineExecutor.executeMethodFromModule(module, memberClass, memberMethod, executionContext);
                return object;
            }
            finally {
                ThreadContextFacade.tearDown();
            }
        }
        throw new ScriptingException(MessageFormat.format("Script Executor of Type [{0}] does not exist, hence the Module [{1}] cannot be processed", engineType, module));
    }

    public static Set<String> getEngineTypes() {
        return ScriptEngineExecutorFactory.getEnginesTypes();
    }

    public static String getEngineTypesAsJson() {
        return GsonHelper.toJson(ScriptEngineExecutorsManager.getEngineTypes());
    }
}

