/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.command.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.engine.command.definition.CommandLine;

public class CommandDefinition {
    private String description;
    private String contentType;
    private List<CommandLine> commands = new ArrayList<CommandLine>();
    private Map<String, String> set = new HashMap<String, String>();
    private List<String> unset = new ArrayList<String>();
    private CommandLine targetCommand;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<CommandLine> getCommands() {
        return this.commands;
    }

    public Map<String, String> getSet() {
        return this.set;
    }

    public List<String> getUnset() {
        return this.unset;
    }

    public CommandLine getTargetCommand() {
        return this.targetCommand;
    }

    public void setTargetCommand(CommandLine targetCommand) {
        this.targetCommand = targetCommand;
    }

    public void validate() throws IllegalArgumentException {
        if (this.getCommands().size() == 0) {
            throw new IllegalArgumentException("Commands array is empty. Set appropriate command per target OS");
        }
        String os = System.getProperty("os.name").toLowerCase();
        for (CommandLine commandLine : this.getCommands()) {
            if (!os.startsWith(commandLine.getOs().toLowerCase())) continue;
            this.setTargetCommand(commandLine);
            break;
        }
        if (this.getTargetCommand() == null) {
            throw new IllegalArgumentException(String.format("There is no command for your OS: %s", os));
        }
    }
}

