/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.command.processor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.api.v3.http.HttpResponseFacade;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.commons.process.Piper;
import org.eclipse.dirigible.commons.process.ProcessUtils;
import org.eclipse.dirigible.engine.api.resource.ResourcePath;
import org.eclipse.dirigible.engine.api.script.AbstractScriptExecutor;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.command.definition.CommandDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandEngineExecutor
extends AbstractScriptExecutor
implements IScriptEngineExecutor {
    private static final String REPOSITORY_ROOT_FOLDER = "REPOSITORY_ROOT_FOLDER";
    private static final String REPOSITORY_FILE_BASED = "REPOSITORY_FILE_BASED";
    private static final Logger logger = LoggerFactory.getLogger(AbstractScriptExecutor.class);
    public static final String ENGINE_TYPE = "command";
    public static final String COMMAND_EXTENSION = ".command";
    public static final String MODULE_EXT_COMMAND = ".command/";
    public static final String ENGINE_NAME = "Execution Command Engine";
    private static final String DIRIGIBLE_EXEC_COMMAND_LOGGING_ENABLED = "DIRIGIBLE_EXEC_COMMAND_LOGGING_ENABLED";

    public String getType() {
        return ENGINE_TYPE;
    }

    public String getName() {
        return ENGINE_NAME;
    }

    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true);
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false);
    }

    public Object evalCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false);
    }

    public Object evalModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true);
    }

    public Object executeMethodFromModule(String module, String memberClass, String memberClassMethod, Map<Object, Object> executionContext) {
        throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " does not support executing ES6 modules!");
    }

    public Object executeService(String moduleOrCode, Map<Object, Object> executionContext, boolean isModule) throws ScriptingException {
        CommandDefinition commandDefinition;
        logger.trace("entering: executeServiceModule()");
        logger.trace("module or code=" + moduleOrCode);
        if (moduleOrCode == null) {
            throw new ScriptingException("Command module name cannot be null");
        }
        if (isModule) {
            ResourcePath resourcePath = this.getResourcePath(moduleOrCode, new String[]{MODULE_EXT_COMMAND});
            moduleOrCode = resourcePath.getModule();
            if (HttpRequestFacade.isValid()) {
                HttpRequestFacade.setAttribute((String)"dirigible-rest-resource-path", (String)resourcePath.getPath());
            }
        }
        String commandSource = isModule ? this.loadSource(moduleOrCode) : moduleOrCode;
        try {
            commandDefinition = (CommandDefinition)GsonHelper.GSON.fromJson(commandSource, CommandDefinition.class);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new ScriptingException((Throwable)e2);
        }
        commandDefinition.validate();
        String commandLine = commandDefinition.getTargetCommand().getCommand();
        String result = this.executeCommandLine(commandLine, commandDefinition.getSet(), commandDefinition.getUnset(), Boolean.parseBoolean(this.getRepository().getParameter(REPOSITORY_FILE_BASED)));
        try {
            HttpResponseFacade.setContentType((String)commandDefinition.getContentType());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.trace("exiting: executeServiceModule()");
        return result;
    }

    public String executeCommandLine(String commandLine, Map<String, String> forAdding, List<String> forRemoving, boolean isFileBasedRepository) throws ScriptingException {
        ByteArrayOutputStream out;
        String[] args;
        try {
            args = ProcessUtils.translateCommandline((String)commandLine);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new ScriptingException((Throwable)e1);
        }
        if (this.shouldLogCommand()) {
            logger.debug("executing command=" + commandLine);
        }
        try {
            ProcessBuilder processBuilder = ProcessUtils.createProcess((String[])args);
            ProcessUtils.addEnvironmentVariables((ProcessBuilder)processBuilder, forAdding);
            ProcessUtils.removeEnvironmentVariables((ProcessBuilder)processBuilder, forRemoving);
            if (isFileBasedRepository) {
                String root = this.getRepository().getParameter(REPOSITORY_ROOT_FOLDER);
                processBuilder.directory(new File(root + "/registry/public"));
            }
            processBuilder.redirectErrorStream(true);
            out = new ByteArrayOutputStream();
            Process process = ProcessUtils.startProcess((String[])args, (ProcessBuilder)processBuilder);
            Piper pipe = new Piper(process.getInputStream(), (OutputStream)out);
            new Thread((Runnable)pipe).start();
            try {
                int i = 0;
                boolean deadYet = false;
                do {
                    Thread.sleep(ProcessUtils.DEFAULT_WAIT_TIME);
                    try {
                        process.exitValue();
                        deadYet = true;
                    }
                    catch (IllegalThreadStateException e) {
                        if (++i < ProcessUtils.DEFAULT_LOOP_COUNT) continue;
                        process.destroy();
                        throw new RuntimeException("Exceeds timeout - " + ProcessUtils.DEFAULT_WAIT_TIME / 1000 * ProcessUtils.DEFAULT_LOOP_COUNT);
                    }
                } while (!deadYet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new IOException(e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ScriptingException((Throwable)e);
        }
        String result = out.toString(StandardCharsets.UTF_8);
        return result;
    }

    private boolean shouldLogCommand() {
        String shouldEnableLogging = Configuration.get((String)DIRIGIBLE_EXEC_COMMAND_LOGGING_ENABLED);
        return Boolean.parseBoolean(shouldEnableLogging);
    }

    private String loadSource(String module) throws ScriptingException {
        if (module == null) {
            throw new ScriptingException("Module location cannot be null");
        }
        byte[] sourceCode = null;
        sourceCode = module.endsWith(COMMAND_EXTENSION) ? this.retrieveModule("/registry/public", module).getContent() : this.retrieveModule("/registry/public", module, COMMAND_EXTENSION).getContent();
        return new String(sourceCode, StandardCharsets.UTF_8);
    }
}

