/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.command.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.dirigible.api.v3.http.HttpResponseFacade;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.api.service.AbstractRestService;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.eclipse.dirigible.engine.command.processor.CommandEngineProcessor;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/command")
@Api(value="Command Engine", authorizations={@Authorization(value="basicAuth", scopes={})})
@ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
public class CommandEngineRestService
extends AbstractRestService
implements IRestService {
    private static final Logger logger = LoggerFactory.getLogger((String)CommandEngineRestService.class.getCanonicalName());
    private CommandEngineProcessor processor = new CommandEngineProcessor();
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeCommandServiceGet(@PathParam(value="path") String path) throws ScriptingException {
        try {
            Object result = this.processor.executeService(path);
            return Response.ok((Object)(result == null ? "null" : result.toString())).type(HttpResponseFacade.getContentType()).build();
        }
        catch (RepositoryNotFoundException e) {
            String message = e.getMessage() + ". Try to publish the service before execution.";
            throw new RepositoryNotFoundException(message, (Throwable)e);
        }
    }

    @POST
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeCommandServicePost(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeCommandServiceGet(path);
    }

    @PUT
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeCommandServicePut(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeCommandServiceGet(path);
    }

    @DELETE
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeCommandServiceDelete(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeCommandServiceGet(path);
    }

    @HEAD
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeCommandServiceHead(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeCommandServiceGet(path);
    }

    public Class<? extends IRestService> getType() {
        return CommandEngineRestService.class;
    }

    protected Logger getLogger() {
        return logger;
    }
}

