/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.debugger;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class DebuggerWebsocketClientEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerWebsocketClientEndpoint.class);
    private Session session = null;
    private MessageHandler messageHandler;

    public DebuggerWebsocketClientEndpoint(URI endpointURI) {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.connectToServer((Object)this, endpointURI);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    @OnOpen
    public void onOpen(Session session) {
        logger.info("[ws:debugger-client] connected: " + session.getId());
        this.session = session;
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        logger.info("[ws:debugger-client] disconnected: " + session.getId());
        this.session = null;
    }

    @OnMessage
    public void onMessage(ByteBuffer message) {
        if (this.messageHandler != null) {
            try {
                this.messageHandler.handleMessage(message);
            }
            catch (IOException e) {
                logger.error("[ws:debugger-client] " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ByteBuffer message) {
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.getBasicRemote().sendBinary(message);
            }
            catch (IOException e) {
                logger.error("[ws:debugger-client] " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface MessageHandler {
        public void handleMessage(ByteBuffer var1) throws IOException;
    }
}

