/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.debugger;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.js.graalvm.debugger.DebuggerWebsocketClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ServerEndpoint(value="/websockets/v4/ide/debugger/{path}")
public class DebuggerWebsocketService {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerWebsocketService.class);
    private static Map<String, Session> OPEN_SESSIONS = new ConcurrentHashMap<String, Session>();
    private static Map<String, DebuggerWebsocketClientEndpoint> SESSION_TO_CLIENT = new ConcurrentHashMap<String, DebuggerWebsocketClientEndpoint>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="path") String path) {
        logger.debug("[ws:debugger] onOpen: " + session.getId());
        try {
            DebuggerWebsocketClientEndpoint clientEndPoint = this.startClientWebsocket(session, path.replace("-", "/"));
            SESSION_TO_CLIENT.put(session.getId(), clientEndPoint);
        }
        catch (URISyntaxException e) {
            logger.error("[ws:debugger] " + e.getMessage(), (Throwable)e);
            try {
                session.close();
            }
            catch (IOException e1) {
                logger.error("[ws:debugger] " + e.getMessage(), (Throwable)e);
            }
        }
        OPEN_SESSIONS.put(session.getId(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(ByteBuffer message, Session session) {
        logger.trace("[ws:debugger] onMessage: " + new String(message.array()));
        DebuggerWebsocketClientEndpoint clientEndPoint = SESSION_TO_CLIENT.get(session.getId());
        if (clientEndPoint != null) {
            DebuggerWebsocketClientEndpoint debuggerWebsocketClientEndpoint = clientEndPoint;
            synchronized (debuggerWebsocketClientEndpoint) {
                clientEndPoint.sendMessage(message);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        logger.info(String.format("[ws:debugger] Session %s error %s", session.getId(), throwable.getMessage()));
        logger.error("[ws:debugger] " + throwable.getMessage(), throwable);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        logger.trace(String.format("[ws:debugger] Session %s closed because of %s", session.getId(), closeReason));
        OPEN_SESSIONS.remove(session.getId());
        DebuggerWebsocketClientEndpoint clientEndPoint = SESSION_TO_CLIENT.remove(session.getId());
        try {
            if (clientEndPoint != null) {
                clientEndPoint.getSession().close();
            }
        }
        catch (IOException e) {
            logger.error("[ws:debugger] " + e.getMessage(), (Throwable)e);
        }
    }

    private DebuggerWebsocketClientEndpoint startClientWebsocket(final Session session, String path) throws URISyntaxException {
        String port = Configuration.get((String)"DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT", (String)"8081");
        DebuggerWebsocketClientEndpoint clientEndPoint = new DebuggerWebsocketClientEndpoint(new URI("ws://localhost:" + port + path));
        clientEndPoint.addMessageHandler(new DebuggerWebsocketClientEndpoint.MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(ByteBuffer message) throws IOException {
                Session session2 = session;
                synchronized (session2) {
                    session.getBasicRemote().sendBinary(message);
                }
            }
        });
        return clientEndPoint;
    }
}

