/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.debugger;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.dirigible.commons.config.Configuration;

public class GraalVMJavascriptDebugProcessor {
    private static final Set<String> OPEN_USER_SESSIONS = ConcurrentHashMap.newKeySet();

    public static boolean haveUserSession(String userName) {
        if (Boolean.parseBoolean(Configuration.get((String)"DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED"))) {
            return OPEN_USER_SESSIONS.contains(userName);
        }
        return false;
    }

    public static void addUserSession(String userName) {
        Configuration.set((String)"DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED", (String)"true");
        OPEN_USER_SESSIONS.add(userName);
    }

    public static void clear() {
        Configuration.set((String)"DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED", (String)"false");
        OPEN_USER_SESSIONS.clear();
    }
}

