/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.dirigible.api.v3.core.ConsoleFacade;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.api.resource.ResourcePath;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.AbstractJavascriptExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptModuleSourceProvider;
import org.eclipse.dirigible.engine.js.graalvm.debugger.GraalVMJavascriptDebugProcessor;
import org.eclipse.dirigible.engine.js.graalvm.processor.GraalVMRepositoryModuleSourceProvider;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalVMJavascriptEngineExecutor
extends AbstractJavascriptExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GraalVMJavascriptEngineExecutor.class);
    private static final String ENGINE_JAVA_SCRIPT = "js";
    private static final String BUILDER_OPTION_INSPECT = "inspect";
    private static final String BUILDER_OPTION_INSPECT_SECURE = "inspect.Secure";
    private static final String BUILDER_OPTION_INSPECT_PATH = "inspect.Path";
    private static final String SOURCE_PROVIDER = "SourceProvider";
    private static final String CODE_DEBUGGER = "debugger;\n\n";
    public static final String ENGINE_NAME = "GraalVM JavaScript Engine";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED = "DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT = "DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS = "DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD = "DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS = "DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_IO = "DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_IO";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN = "DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN";
    public static final String DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA = "DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA";
    public static final String DEFAULT_DEBUG_PORT = "8081";
    private GraalVMRepositoryModuleSourceProvider sourceProvider = new GraalVMRepositoryModuleSourceProvider((IScriptEngineExecutor)this, "/registry/public");

    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true);
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false);
    }

    public Object executeService(String moduleOrCode, Map<Object, Object> executionContext, boolean isModule) throws ScriptingException {
        logger.trace("entering: executeServiceModule()");
        logger.trace("module or code=" + moduleOrCode);
        if (moduleOrCode == null) {
            throw new ScriptingException("JavaScript module name cannot be null");
        }
        if (isModule) {
            ResourcePath resourcePath = this.getResourcePath(moduleOrCode, new String[]{".js/", ".graalvm/"});
            moduleOrCode = resourcePath.getModule();
            if (HttpRequestFacade.isValid()) {
                HttpRequestFacade.setAttribute((String)"dirigible-rest-resource-path", (String)resourcePath.getPath());
            }
        }
        Object result = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        Bindings engineBindings = engine.getBindings(100);
        engineBindings.put("polyglot.js.allowHostAccess", (Object)true);
        engineBindings.put("polyglot.js.allowHostClassLookup", s -> true);
        Context.Builder contextBuilder = Context.newBuilder((String[])new String[]{ENGINE_JAVA_SCRIPT}).allowEnvironmentAccess(EnvironmentAccess.INHERIT).option("js.ecmascript-version", "2021");
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS, (String)"true"))) {
            contextBuilder.allowHostClassLookup(s -> true).allowHostAccess(HostAccess.ALL).allowAllAccess(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD, (String)"true"))) {
            contextBuilder.allowCreateThread(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_IO, (String)"true"))) {
            contextBuilder.allowIO(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS, (String)"true"))) {
            contextBuilder.allowCreateProcess(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN, (String)"true"))) {
            contextBuilder.option("js.nashorn-compat", "true");
        }
        if (isDebugEnabled) {
            contextBuilder.option(BUILDER_OPTION_INSPECT, Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT, (String)DEFAULT_DEBUG_PORT));
            contextBuilder.option(BUILDER_OPTION_INSPECT_SECURE, Boolean.FALSE.toString());
            contextBuilder.option(BUILDER_OPTION_INSPECT_PATH, moduleOrCode);
        }
        try (Context context = contextBuilder.build();){
            Object code = isModule ? this.loadSource(moduleOrCode) : moduleOrCode;
            Value bindings = context.getBindings(ENGINE_JAVA_SCRIPT);
            bindings.putMember(SOURCE_PROVIDER, (Object)this.getSourceProvider());
            bindings.putMember("__engine", (Object)"graalvm");
            bindings.putMember("__context", executionContext);
            bindings.putMember("console", (Object)ConsoleFacade.getConsole());
            context.eval(ENGINE_JAVA_SCRIPT, (CharSequence)"var Require = (function(modulePath) {\tvar _loadedModules = {}; var _require = function(path) { var moduleInfo, buffered, head = '(function(exports,module,require){ ', code = '', tail = '})', line = null; moduleInfo = _loadedModules[path]; if (moduleInfo) {   return moduleInfo; } code = SourceProvider.loadSource(path); moduleInfo = {   loaded : false,   id : path,   exports : {},   require : _requireClosure() }; code = head + code + tail; _loadedModules[path] = moduleInfo; var compiledWrapper = null; try {   compiledWrapper = eval(code); } catch (e) {   throw new Error('Error evaluating module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } var parameters = [ moduleInfo.exports, /* exports */   moduleInfo, /* module */   moduleInfo.require /* require */ ]; try {   compiledWrapper.apply(moduleInfo.exports, /* this */   parameters); } catch (e) {   throw new Error('Error executing module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } moduleInfo.loaded = true; return moduleInfo;};var _requireClosure = function() {  return function(path) {  var module = _require(path);  return module.exports; };};return _requireClosure();});var require = Require();");
            if (Boolean.parseBoolean(Configuration.get((String)DIRIGBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA, (String)"false"))) {
                context.eval(ENGINE_JAVA_SCRIPT, (CharSequence)"load(\"nashorn:mozilla_compat.js\")");
            }
            this.beforeEval(context);
            if (isDebugEnabled) {
                code = CODE_DEBUGGER + (String)code;
            }
            result = context.eval(ENGINE_JAVA_SCRIPT, (CharSequence)code).as(Object.class);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.trace("exiting: executeServiceModule()");
        return result;
    }

    protected String loadSource(String module) throws IOException, URISyntaxException {
        return this.getSourceProvider().loadSource(module);
    }

    protected void beforeEval(Context context) throws IOException {
    }

    private boolean isDebugEnabled() {
        return GraalVMJavascriptDebugProcessor.haveUserSession(UserFacade.getName());
    }

    public String getType() {
        return "graalvm";
    }

    public String getName() {
        return ENGINE_NAME;
    }

    public IJavascriptModuleSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

