/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptModuleSourceProvider;

public class GraalVMRepositoryModuleSourceProvider
implements IJavascriptModuleSourceProvider {
    private static final String JS_EXTENSION = ".js";
    private IScriptEngineExecutor executor;
    private String root;

    public GraalVMRepositoryModuleSourceProvider(IScriptEngineExecutor executor, String root) {
        this.executor = executor;
        this.root = root;
    }

    public String loadSource(String module) throws IOException, URISyntaxException {
        if (module == null) {
            throw new IOException("Module location cannot be null");
        }
        byte[] sourceCode = null;
        sourceCode = module.endsWith(JS_EXTENSION) ? this.executor.retrieveModule(this.root, module).getContent() : this.executor.retrieveModule(this.root, module, JS_EXTENSION).getContent();
        return new String(sourceCode, StandardCharsets.UTF_8);
    }
}

