/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-FileCopyrightText: 2022 SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.truffle;

/**
 * The Class Constants.
 */
class Constants {
    
    /** The Constant DIRIGIBLE_SCOPE_VERSIONED. */
    static final String DIRIGIBLE_SCOPE_VERSIONED = "/@dirigible-";
    
    /** The Constant DIRIGIBLE_SCOPE_DEFAULT. */
    static final String DIRIGIBLE_SCOPE_DEFAULT = "/@dirigible";
    
    /** The Constant MJS_EXTENSION. */
    static final String MJS_EXTENSION = ".mjs";
    
    /** The Constant JS_EXTENSION. */
    static final String JS_EXTENSION = ".js";
    
    /** The Constant SCOPED_PATH_SEPARATOR. */
    static final String SCOPED_PATH_SEPARATOR = "-";
    
    /** The Constant PATH_SEPARATOR. */
    static final String PATH_SEPARATOR = "/";
    
    /** The Constant CURRENT_DIRECTORY. */
    static final String CURRENT_DIRECTORY = "./";
    
    /** The Constant PARENT_DIRECTORY. */
    static final String PARENT_DIRECTORY = "../";
}
