/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.callbacks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class Require {
    public static final String CODE = Require.createRequireFunctionCode("require");
    public static final String DIRIGIBLE_REQUIRE_CODE = Require.createRequireFunctionCode("dirigibleRequire");
    public static final String MODULE_CREATE_CODE = "let mainModule = createModule(\".\");\nmainModule;";
    public static final String MODULE_LOAD_CODE = "mainModule.load(MODULE_FILENAME);";
    public static final String LOAD_STRING_CODE = "mainModule.loadScriptString(SCRIPT_STRING);";
    public static final String LOAD_CONSOLE_CODE = "let console = {};\nconsole.log = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.log(stringify(message));\n};\n\nconsole.error = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.error(stringify(message));\n};\n\nconsole.info = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.info(stringify(message));\n};\n\nconsole.warn = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.warn(stringify(message));\n};\n\nconsole.debug = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.debug(stringify(message));\n};\n\nconsole.trace = function(message) {\n\tlet traceMessage = new Error(stringify(`${message}`)).stack;\n\tif (traceMessage) {\n\t\ttraceMessage = traceMessage.substring(\"Error: \".length, traceMessage.length);\n\t}\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.trace(traceMessage);\n};\n\nfunction stringify(message) {\n\tif (typeof message === 'object' && message !== null && message.class === undefined) {\n\t\treturn JSON.stringify(message);\n\t}\n\treturn \"\" + message;\n}";

    private static final String createRequireFunctionCode(String functionName) {
        return "var Require = (function(modulePath) {\tvar _loadedModules = {}; var _require = function(path) { var moduleInfo, buffered, head = '(function(exports,module,require){ ', code = '', tail = '})', line = null; moduleInfo = _loadedModules[path]; if (moduleInfo) {   return moduleInfo; } code = SourceProvider.loadSource(path); moduleInfo = {   loaded : false,   id : path,   exports : {},   require : _requireClosure() }; code = head + code + tail; _loadedModules[path] = moduleInfo; var compiledWrapper = null; try {   compiledWrapper = load({ name: path, script: code}); } catch (e) {   throw new Error('Error evaluating module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } var parameters = [ moduleInfo.exports, /* exports */   moduleInfo, /* module */   moduleInfo.require /* require */ ]; try {   compiledWrapper.apply(moduleInfo.exports, /* this */   parameters); } catch (e) {   throw new Error('Error executing module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } moduleInfo.loaded = true; return moduleInfo;};var _requireClosure = function() {  return function(path) {  var module = _require(path);  return module.exports; };};return _requireClosure();});globalThis." + functionName + " = Require();";
    }

    public static final String MODULE_CODE() throws IOException {
        return IOUtils.toString((InputStream)Require.class.getResourceAsStream("/Module.js"), (Charset)Charset.defaultCharset());
    }
}

