/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.js.graalvm.debugger.GraalVMJavascriptDebugProcessor;
import org.eclipse.dirigible.engine.js.graalvm.processor.truffle.RegistryTruffleFileSystem;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.io.FileSystem;

class GraalVMJavaScriptContextBuilder {
    private static final String BUILDER_OPTION_INSPECT = "inspect";
    private static final String BUILDER_OPTION_INSPECT_SECURE = "inspect.Secure";
    private static final String BUILDER_OPTION_INSPECT_PATH = "inspect.Path";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED = "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT = "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS = "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD = "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS = "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_IO = "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_IO";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN = "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN";
    private static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA = "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA";
    public static final String DEFAULT_DEBUG_PORT = "8081";

    GraalVMJavaScriptContextBuilder() {
    }

    Context createJavaScriptContext(String moduleOrCode, Function<String, RegistryTruffleFileSystem> truffleFileSystemProvider) {
        Context.Builder contextBuilder = Context.newBuilder((String[])new String[]{"js"}).allowEnvironmentAccess(EnvironmentAccess.INHERIT).allowExperimentalOptions(true).option("js.ecmascript-version", "2022").option("engine.WarnInterpreterOnly", "false");
        if (moduleOrCode.endsWith(".mjs")) {
            if (moduleOrCode.startsWith("/")) {
                moduleOrCode = StringUtils.substringAfter((String)moduleOrCode, (String)"/");
            }
            String project = StringUtils.substringBeforeLast((String)moduleOrCode, (String)"/");
            RegistryTruffleFileSystem registryTruffleFileSystem = truffleFileSystemProvider.apply(project);
            contextBuilder.fileSystem((FileSystem)registryTruffleFileSystem);
            contextBuilder.option("js.esm-eval-returns-exports", "true");
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS, (String)"true"))) {
            contextBuilder.allowHostClassLookup(s -> true).allowHostAccess(HostAccess.ALL).allowAllAccess(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD, (String)"true"))) {
            contextBuilder.allowCreateThread(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_IO, (String)"true"))) {
            contextBuilder.allowIO(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS, (String)"true"))) {
            contextBuilder.allowCreateProcess(true);
        }
        if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN, (String)"true"))) {
            contextBuilder.option("js.nashorn-compat", "true");
        }
        if (this.isDebugEnabled()) {
            contextBuilder.option(BUILDER_OPTION_INSPECT, Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT, (String)DEFAULT_DEBUG_PORT));
            contextBuilder.option(BUILDER_OPTION_INSPECT_SECURE, Boolean.FALSE.toString());
            contextBuilder.option(BUILDER_OPTION_INSPECT_PATH, moduleOrCode);
        }
        return contextBuilder.build();
    }

    private boolean isDebugEnabled() {
        return GraalVMJavascriptDebugProcessor.haveUserSession(UserFacade.getName());
    }
}

