/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.api.resource.ResourcePath;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.AbstractJavascriptExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptModuleSourceProvider;
import org.eclipse.dirigible.engine.js.graalvm.callbacks.Require;
import org.eclipse.dirigible.engine.js.graalvm.debugger.GraalVMJavascriptDebugProcessor;
import org.eclipse.dirigible.engine.js.graalvm.processor.ExecutableFileType;
import org.eclipse.dirigible.engine.js.graalvm.processor.ExecutableFileTypeResolver;
import org.eclipse.dirigible.engine.js.graalvm.processor.GraalVMJavaScriptContextBuilder;
import org.eclipse.dirigible.engine.js.graalvm.processor.GraalVMRepositoryModuleSourceProvider;
import org.eclipse.dirigible.engine.js.graalvm.processor.truffle.RegistryTruffleFileSystem;
import org.eclipse.dirigible.graalium.core.javascript.JavascriptCodeRunner;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalVMJavascriptEngineExecutor
extends AbstractJavascriptExecutor
implements JavascriptCodeRunner<String, Object> {
    private static final Logger logger = LoggerFactory.getLogger(GraalVMJavascriptEngineExecutor.class);
    private static final String ENGINE_JAVA_SCRIPT = "js";
    private static final String SOURCE_PROVIDER = "SourceProvider";
    private static final String CODE_DEBUGGER = "debugger;\n\n";
    public static final String ENGINE_NAME = "GraalVM JavaScript Engine";
    public static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED = "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_ENABLED";
    public static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT = "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT";
    public static final String DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA = "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA";
    public static final String DEFAULT_DEBUG_PORT = "8081";
    private final GraalVMRepositoryModuleSourceProvider sourceProvider = new GraalVMRepositoryModuleSourceProvider((IScriptEngineExecutor)this, "/registry/public");
    private final ExecutableFileTypeResolver executableFileTypeResolver = new ExecutableFileTypeResolver();

    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true, true);
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false, true);
    }

    public Object evalCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false, false);
    }

    public Object evalModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true, false);
    }

    public Object executeMethodFromModule(String module, String memberClass, String memberMethod, Map<Object, Object> executionContext) {
        CompletableFuture res = new CompletableFuture();
        this.executeService(module, executionContext, true, false, (context, value) -> {
            if (memberClass != null && !memberClass.isEmpty()) {
                Value memberClassValue = value.getMember(memberClass);
                Value memberClassInstanceValue = memberClassValue.newInstance(new Object[0]);
                Value memberClassMethodValue = memberClassInstanceValue.getMember(memberMethod);
                Value executionResult = memberClassMethodValue.execute(new Object[0]);
                res.complete(executionResult);
            } else {
                Value memberMethodValue = value.getMember(memberMethod);
                Value executionResult = memberMethodValue.execute(new Object[0]);
                res.complete(executionResult);
            }
        });
        try {
            return res.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new ScriptingException((Throwable)e);
        }
    }

    public Object run(Path codeFilePath) {
        return this.executeServiceModule(codeFilePath.toString(), new HashMap<Object, Object>());
    }

    public Object run(String codeSource) {
        return this.executeServiceCode(codeSource, new HashMap<Object, Object>());
    }

    public Object executeService(String moduleOrCode, Map<Object, Object> executionContext, boolean isModule, boolean commonJSModule) throws ScriptingException {
        return this.executeService(moduleOrCode, executionContext, isModule, commonJSModule, (c, v) -> {});
    }

    public Object executeService(String moduleOrCode, Map<Object, Object> executionContext, boolean isModule, boolean commonJSModule, BiConsumer<Context, Value> onAfterExecute) throws ScriptingException {
        if (moduleOrCode == null) {
            throw new ScriptingException("JavaScript module name cannot be null");
        }
        logger.trace("entering: executeServiceModule()");
        logger.trace("module or code=" + moduleOrCode);
        if (executionContext == null) {
            executionContext = new HashMap<Object, Object>();
        }
        if (isModule) {
            ResourcePath resourcePath = this.getResourcePath(moduleOrCode, new String[]{".js/", ".mjs/", ".graalvm/"});
            moduleOrCode = resourcePath.getModule();
            if (HttpRequestFacade.isValid()) {
                HttpRequestFacade.setAttribute((String)"dirigible-rest-resource-path", (String)resourcePath.getPath());
            }
        }
        boolean isDebugEnabled = this.isDebugEnabled();
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        Bindings engineBindings = engine.getBindings(100);
        engineBindings.put("polyglot.js.allowHostAccess", (Object)true);
        engineBindings.put("polyglot.js.allowHostClassLookup", s -> true);
        Object result = null;
        GraalVMJavaScriptContextBuilder contextBuilder = new GraalVMJavaScriptContextBuilder();
        try (Context context = contextBuilder.createJavaScriptContext(moduleOrCode, projectName -> new RegistryTruffleFileSystem((IScriptEngineExecutor)this, (String)projectName));){
            ExecutableFileType executableFileType;
            Value bindings = context.getBindings(ENGINE_JAVA_SCRIPT);
            bindings.putMember(SOURCE_PROVIDER, (Object)this.getSourceProvider());
            bindings.putMember("__engine", (Object)"graalvm");
            bindings.putMember("__context", executionContext);
            if (Boolean.parseBoolean(Configuration.get((String)DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA, (String)"false"))) {
                context.eval(ENGINE_JAVA_SCRIPT, (CharSequence)"load(\"nashorn:mozilla_compat.js\")");
            }
            if ((executableFileType = this.executableFileTypeResolver.resolveFileType(moduleOrCode, commonJSModule)) == ExecutableFileType.JAVASCRIPT_ESM) {
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)Require.CODE, (String)"internal-require.js").internal(true).build());
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)Require.DIRIGIBLE_REQUIRE_CODE, (String)"internal-dirigible-require.js").internal(true).build());
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"globalThis.console = require('core/v4/console');", (String)"internal-console.js").internal(true).build());
                String fileName = isModule ? moduleOrCode : "unknown";
                String code = isModule ? this.loadSource(moduleOrCode) : moduleOrCode;
                Source src = Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)code, (String)fileName).mimeType("application/javascript+module").build();
                this.beforeEval(context);
                Value evaluated = context.eval(src);
                onAfterExecute.accept(context, evaluated);
                result = null;
            } else if (executableFileType == ExecutableFileType.JAVASCRIPT_NODE_CJS) {
                Source source;
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"let console = {};\nconsole.log = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.log(stringify(message));\n};\n\nconsole.error = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.error(stringify(message));\n};\n\nconsole.info = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.info(stringify(message));\n};\n\nconsole.warn = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.warn(stringify(message));\n};\n\nconsole.debug = function(message) {\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.debug(stringify(message));\n};\n\nconsole.trace = function(message) {\n\tlet traceMessage = new Error(stringify(`${message}`)).stack;\n\tif (traceMessage) {\n\t\ttraceMessage = traceMessage.substring(\"Error: \".length, traceMessage.length);\n\t}\n\torg.eclipse.dirigible.api.v3.core.ConsoleFacade.trace(traceMessage);\n};\n\nfunction stringify(message) {\n\tif (typeof message === 'object' && message !== null && message.class === undefined) {\n\t\treturn JSON.stringify(message);\n\t}\n\treturn \"\" + message;\n}", (String)"internal-console.js").internal(true).build());
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)Require.MODULE_CODE(), (String)"Module.js").build());
                Object mainModule = context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"let mainModule = createModule(\".\");\nmainModule;", (String)"internal-module-create-code.js").build()).as(Object.class);
                executionContext.put("main_module", mainModule);
                this.beforeEval(context);
                if (isModule) {
                    bindings.putMember("MODULE_FILENAME", (Object)moduleOrCode);
                    source = Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"mainModule.load(MODULE_FILENAME);", (String)"internal-module-load-code.js").build();
                } else {
                    bindings.putMember("SCRIPT_STRING", (Object)moduleOrCode);
                    source = Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"mainModule.loadScriptString(SCRIPT_STRING);", (String)"internal-module-load-string-code.js").build();
                }
                Value evaluated = context.eval(source);
                onAfterExecute.accept(context, evaluated);
            } else {
                Object code;
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)Require.CODE, (String)"internal-require.js").internal(true).build());
                context.eval(Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)"globalThis.console = require('core/v4/console');", (String)"internal-console.js").internal(true).build());
                Object object = code = isModule ? this.loadSource(moduleOrCode) : moduleOrCode;
                if (isDebugEnabled) {
                    code = CODE_DEBUGGER + (String)code;
                }
                this.beforeEval(context);
                Source source = Source.newBuilder((String)ENGINE_JAVA_SCRIPT, (CharSequence)code, (String)(isModule ? moduleOrCode : "unknown")).build();
                Value evaluated = context.eval(source);
                onAfterExecute.accept(context, evaluated);
                result = evaluated.as(Object.class);
            }
        }
        logger.trace("exiting: executeServiceModule()");
        return result;
    }

    protected String loadSource(String module) throws IOException, URISyntaxException {
        return this.getSourceProvider().loadSource(module);
    }

    protected void beforeEval(Context context) throws IOException {
    }

    private boolean isDebugEnabled() {
        return GraalVMJavascriptDebugProcessor.haveUserSession(UserFacade.getName());
    }

    public String getType() {
        return "graalvm";
    }

    public String getName() {
        return ENGINE_NAME;
    }

    public IJavascriptModuleSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void close() {
    }
}

