/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.compilation;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dirigible.repository.api.CaffeineRepositoryCache;

class TypeScriptCompilerFacade {
    TypeScriptCompilerFacade() {
    }

    void handleTypeScriptFile(String relativeProjectFilePath) throws IOException, InterruptedException {
        String projectPath = "/Users/xxxxxx/target/dirigible/repository/root/registry/public/";
        String filePath = projectPath + relativeProjectFilePath;
        String fileDirectoryPath = StringUtils.substringBeforeLast((String)filePath, (String)"/");
        this.createIndexDtsFile(fileDirectoryPath);
        this.compileTypeScriptFile(filePath);
        this.invalidateCache(fileDirectoryPath);
    }

    private void createIndexDtsFile(String fileDirectoryPath) throws IOException {
        File indexDtsFile = new File(fileDirectoryPath + "/index.d.ts");
        FileUtils.writeStringToFile((File)indexDtsFile, (String)"declare const require: any;", (Charset)StandardCharsets.UTF_8);
    }

    private void compileTypeScriptFile(String filePath) throws InterruptedException, IOException {
        Runtime runtime = Runtime.getRuntime();
        String[] command = new String[]{"tsc index.d.ts ", filePath};
        Process pr = runtime.exec(command);
        pr.waitFor();
    }

    private void invalidateCache(String fileDirectoryPath) {
        Cache cache = CaffeineRepositoryCache.getInternalCache();
        List keys = cache.asMap().keySet().stream().filter(key -> key.startsWith(fileDirectoryPath)).collect(Collectors.toList());
        cache.invalidateAll(keys);
    }
}

