/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.generation;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.api.script.Module;
import org.eclipse.dirigible.engine.js.graalvm.processor.generation.ApiModule;
import org.eclipse.dirigible.engine.js.graalvm.processor.generation.MultipleMatchingApiPathsException;

public class ExportGenerator {
    private final IScriptEngineExecutor executor;
    private static final String apiModuleJsonPath = "/extensions/modules.json";
    private static final String NAME_PLACEHOLDER = "<name_placeholder>";
    private static final String PATH_PLACEHOLDER = "<path_placeholder>";
    private static final String NAMES_LIST_PLACEHOLDER = "<names_list_placeholder>";
    private static final String DEFAULT_EXPORT_PATTERN = "export default { <names_list_placeholder> }";
    private static final String EXPORT_PATTERN = "export const <name_placeholder> = dirigibleRequire('<path_placeholder>');";

    public ExportGenerator(IScriptEngineExecutor executor) {
        this.executor = executor;
    }

    public String generate(String path, String apiVersion) {
        path = (String)path + apiModuleJsonPath;
        ApiModule[] modules = this.readApiModuleJson((String)path);
        StringBuilder source = new StringBuilder();
        StringBuilder moduleNames = new StringBuilder();
        for (ApiModule module : modules) {
            if (module.isPackageDescription() || module.getShouldBeUnexposedToESM()) continue;
            String api = module.getApi();
            String dir = this.resolvePath(module, apiVersion);
            source.append(EXPORT_PATTERN.replace(NAME_PLACEHOLDER, api).replace(PATH_PLACEHOLDER, dir));
            source.append(System.lineSeparator());
            moduleNames.append(api);
            moduleNames.append(',');
        }
        if (moduleNames.length() > 0) {
            moduleNames.setLength(moduleNames.length() - 1);
        }
        source.append(DEFAULT_EXPORT_PATTERN.replace(NAMES_LIST_PLACEHOLDER, moduleNames.toString()));
        source.append(System.lineSeparator());
        return source.toString();
    }

    private ApiModule[] readApiModuleJson(String path) {
        Gson gson = new Gson();
        Module module = this.executor.retrieveModule("/registry/public", path.replace(".json", ""), ".json");
        String apiModuleJson = new String(module.getContent(), StandardCharsets.UTF_8);
        return (ApiModule[])gson.fromJson(apiModuleJson, ApiModule[].class);
    }

    private String resolvePath(ApiModule module, String apiVersion) {
        if (apiVersion.isEmpty()) {
            return module.getPathDefault();
        }
        List foundPaths = Arrays.stream(module.getVersionedPaths()).filter(p -> p.contains(apiVersion)).collect(Collectors.toList());
        if (foundPaths.size() == 1) {
            return (String)foundPaths.get(0);
        }
        StringBuilder message = new StringBuilder();
        message.append("Searching for single api path containing '");
        message.append(apiVersion);
        message.append("' but found: ");
        for (String item : foundPaths) {
            message.append("'");
            message.append(item);
            message.append("' ");
        }
        throw new MultipleMatchingApiPathsException(message.toString());
    }
}

