/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.truffle;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.graalvm.processor.generation.ExportGenerator;

class DirigibleScopePathHandler {
    private final ExportGenerator generator;

    DirigibleScopePathHandler(IScriptEngineExecutor executor) {
        this.generator = new ExportGenerator(executor);
    }

    String resolve(String pathString) {
        if (pathString.startsWith("/@dirigible-native/")) {
            String packageName = this.parseImportedJavaPackage(pathString);
            List<ClassName> classes = this.getClassesInPackage(packageName);
            return this.generateJavaExports(classes);
        }
        if (pathString.startsWith("/@dirigible-")) {
            return this.resolveVersionedScopePath(pathString);
        }
        if (pathString.startsWith("/@dirigible")) {
            return this.resolveDefaultScopePath(pathString);
        }
        return "";
    }

    private String resolveVersionedScopePath(String pathString) {
        pathString = pathString.substring("/@dirigible-".length() - 1);
        pathString = pathString.replace("-", "/");
        String apiVersion = pathString.split("/")[1];
        String apiVersionPath = "/" + apiVersion;
        pathString = pathString.replace(apiVersionPath, "");
        return this.generator.generate(pathString, apiVersion);
    }

    private String resolveDefaultScopePath(String pathString) {
        pathString = pathString.substring("/@dirigible".length());
        pathString = pathString.replace("-", "/");
        return this.generator.generate(pathString, "");
    }

    private String parseImportedJavaPackage(String importString) {
        String packageName = StringUtils.substringAfter((String)importString, (String)"/@dirigible-native/");
        return packageName;
    }

    private List<ClassName> getClassesInPackage(String packageName) {
        HashSet<ClassName> classNames = new HashSet<ClassName>();
        try (ScanResult scanResult = new ClassGraph().verbose().enableClassInfo().enableSystemJarsAndModules().acceptPackages(new String[]{packageName}).scan();){
            for (ClassInfo classInfo : scanResult.getAllClasses()) {
                ClassName className = new ClassName(classInfo.getSimpleName(), classInfo.getName());
                classNames.add(className);
            }
        }
        return new ArrayList<ClassName>(classNames);
    }

    private String generateJavaExports(List<ClassName> classes) {
        StringBuilder exportsBuilder = new StringBuilder();
        ArrayList<String> exportedSymbolNames = new ArrayList<String>();
        for (ClassName klass : classes) {
            if (!StringUtils.isAlphanumeric((CharSequence)klass.getClassName())) continue;
            exportsBuilder.append("export const ").append(klass.getClassName()).append(" = Java.type('").append(klass.getPackageAndClassName()).append("');").append(System.lineSeparator());
            exportedSymbolNames.add(klass.getClassName());
        }
        exportsBuilder.append(System.lineSeparator()).append("export default { ").append(StringUtils.join(exportedSymbolNames, (String)",")).append(" }");
        return exportsBuilder.toString();
    }

    public static class ClassName {
        private final String className;
        private final String packageAndClassName;

        public ClassName(String className, String packageAndClassName) {
            this.className = className;
            this.packageAndClassName = packageAndClassName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getPackageAndClassName() {
            return this.packageAndClassName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassName className1 = (ClassName)o;
            return Objects.equals(this.className, className1.className);
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }
    }
}

